// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Mapi for sending files and decrypting messages..
//.................................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include <Mapi.h>
#include <richedit.h>
#include <string.h>
#include <ole2.h>
//#include <ssce.h>
#define STRSAFE_LIB
#include <strsafe.h>

// A few definitions.
//...................
#define ADDR_MAX            128
#define MAXUSERS            10
#define TO_EDIT_MAX         (8 * 1024)
#define CC_EDIT_MAX         (8 * 1024)
#define	BCC_EDIT_MAX		(8 * 1024)
#define SUBJECT_EDIT_MAX    128
#define NOTE_LINE_MAX       1024
#define FILE_ATTACH_MAX     32

extern	DWORD			dwStringSafeFlag;
extern	BOOL			bProcessInProgress;
extern	TCHAR			szDestination[MAX_PATH];
extern	HWND			hMainWindow;
extern	HINSTANCE		hInst;
extern	LPCTSTR			lpszAppName;
extern	LPCTSTR			lpIconPointer;
extern	LPTSTR			lpszNA;
extern	LPBYTE			lpFileName;
extern	TCHAR			Header1[];
extern	BOOL			bIsWin9x;
extern	TCHAR			Header1[];
extern	TCHAR			Footer1[];
extern	LPBYTE			lpLineFeed;
extern	LPBYTE			lpSearchEDI;
extern	UINT			uFormat;
extern	TCHAR			szFileToDecipher[MAX_PATH];
extern	TCHAR			szDestination[MAX_PATH];
extern	TCHAR			szFileToEncipher[MAX_PATH];
extern	TCHAR			szFileName[MAX_PATH];
extern	HANDLE			hInputFile;
extern	DWORD			dwSource;
extern	HANDLE			hSendersEvent;
extern	HANDLE			hSendersOpen;
extern	BOOL			bEditWindowDisplayed;
extern	HWND			hEditListWindow;
extern	HWND			hEditWindow;
extern	LPCTSTR			lpszNullString;
extern	HCURSOR			hCursorWait;
extern	BOOL			bRtfLib;
extern	UINT			uComDlgHelpMsg;
extern	TCHAR			szClipboardTsc;
extern	LPCTSTR			lpszStopSign;
extern	TCHAR			szMyReplyFile[MAX_PATH];
extern	DWORD			dwMyReplyFormat;
extern	BOOL			bDeleteReplyFile;
extern	HANDLE			hDlgCurrent;
extern	BOOL			bAddressBookDisplayed;
extern	LPCTSTR			lpszNullString;
extern	BOOL			bUseNew;
extern	BOOL			bNeedDestination;
extern	BOOL			bPackingRequired;
extern	BOOL			bWipeAfterEncryption;
extern	BOOL			bWipeIntermediate;
extern	BOOL			bWipeFiles;
extern	BOOL			bCancelOperation;
extern	BOOL			bAa;
extern	BOOL			bRestrictionsInEffect;
extern	TCHAR			szOSName[512];
extern	DWORD			dwMajor;
extern	DWORD			dwMinor;
extern	DWORD			dwShellMajor;
extern	DWORD			dwShellMinor;
extern	DWORD			dwSlwapiMajor;
extern	DWORD			dwSlwapiMinor;
extern	TCHAR			szMailClient[64];
extern	TCHAR			szMailClientDll[MAX_PATH];
extern	TCHAR			szPreviousDestinationDir[MAX_PATH];
extern	BOOL			bHaveRichEdit3;
extern	BOOL			bSkipTheRest;
extern	TCHAR			szIPAddress[32];
extern	DWORD			dwTip;
extern	DWORD			dwTipString;
extern	BOOL			bUseSentrySpellChecker;
extern	TCHAR			szCheckSpellingDlg;
extern	TCHAR			szEditLexDlg;
extern	TCHAR			szOptionsDlg;
extern	TCHAR			szNewLexDlg;
extern	TCHAR			szMailClientDll[MAX_PATH];
extern	TCHAR			szMailClient[64];
extern	BOOL			bWin2000OrGreater;
extern	LPFINDREPLACE	lpFr;
extern	UINT			uFindMsgString;
extern	COLORREF		crOleBkg;
extern	BOOL			bShowPreviousEncFolder;
extern	CONFIG			cfg;
extern	HCURSOR			hCursorArrow;
extern	TCHAR			szMyRichEditCtrl[16];
extern	BOOL			bHaveRichEdit41orGreater;

#undef MAPILogon
#undef MAPILogoff
#undef MAPISendMail
#undef MAPISendDocuments
#undef MAPIFindNext
#undef MAPIReadMail
#undef MAPISaveMail
#undef MAPIDeleteMail
#undef MAPIFreeBuffer
#undef MAPIAddress
#undef MAPIDetails
#undef MAPIResolveName

#define MAPILogon           (*lpfnMAPILogon)
#define MAPILogoff          (*lpfnMAPILogoff)
#define MAPISendMail        (*lpfnMAPISendMail)
#define MAPISendDocuments   (*lpfnMAPISendDocuments)
#define MAPIFindNext        (*lpfnMAPIFindNext)
#define MAPIReadMail        (*lpfnMAPIReadMail)
#define MAPISaveMail        (*lpfnMAPISaveMail)
#define MAPIDeleteMail      (*lpfnMAPIDeleteMail)
#define MAPIFreeBuffer      (*lpfnMAPIFreeBuffer)
#define MAPIAddress         (*lpfnMAPIAddress)
#define MAPIDetails         (*lpfnMAPIDetails)
#define MAPIResolveName     (*lpfnMAPIResolveName)

LPMAPILOGON				lpfnMAPILogon;
LPMAPILOGOFF			lpfnMAPILogoff;
LPMAPISENDMAIL			lpfnMAPISendMail;
LPMAPISENDDOCUMENTS		lpfnMAPISendDocuments;
LPMAPIFINDNEXT			lpfnMAPIFindNext;
LPMAPIREADMAIL			lpfnMAPIReadMail;
LPMAPISAVEMAIL			lpfnMAPISaveMail;
LPMAPIDELETEMAIL		lpfnMAPIDeleteMail;
LPMAPIFREEBUFFER		lpfnMAPIFreeBuffer;
LPMAPIADDRESS			lpfnMAPIAddress;
LPMAPIDETAILS			lpfnMAPIDetails;
LPMAPIRESOLVENAME		lpfnMAPIResolveName;

// Variable for MAPISendDocuments.
//................................
LPTSTR			lpszDelimChar = ";";
HANDLE			hLibrary;
LPTSTR			lpMapiDllName;

// The message variables.
//.......................
lpMapiMessage	lpmsg = NULL;
lpMapiMessage	lpReadMsg;
LPMSGID			lpReadMsgNode;
LPTSTR			lpszSubject;
LPTSTR			lpszNoteText;
ULONG			cRecips;
ULONG			cNewRecips;
ULONG			cAttach;
lpMapiRecipDesc	lpRecips;
lpMapiRecipDesc	lpNewRecips;
lpMapiFileDesc	lpAttach;

ULONG			flSendMsgFlags = 0;
BOOL			bReturnReceipt = FALSE;
BOOL			bLoggedOn = FALSE;
BOOL			bCanceledMsgEncryption;
LHANDLE			lHandle = 0;
HCURSOR			hOldCur = 0;
LPTSTR			lpMapiFunction = "Simple MAPI Function.";
LPTSTR			lpszRTF = "Rich Text Edit Control";
BOOL			bChooseBkgColor;
BOOL			bChooseHighLightColor;
BOOL			bSaveAsText;
CHOOSECOLOR		crBkg;
CHOOSECOLOR		crText;
COLORREF		crBkgCurrent = 0xffffff;
COLORREF		crSetBkgColor = 0xffffff;
COLORREF		crTextCurrent;
TCHAR			szClipboardRtf[] = "Clipboard.rtf";
DWORD			dwSpellHelp;
BOOL			bTempRtf;
BOOL			bWipeAfterAttach;
BOOL			bCompressAndEncrypt;
BOOL			bReplyToDecrypted;
BYTE			szDisplayNames[TO_EDIT_MAX];
BYTE			szUnResNames[CC_EDIT_MAX];
BYTE			szBcc[BCC_EDIT_MAX];
TCHAR			szAttachSaved[] = "%d out of %d file attachments successfully saved to disk.";
TCHAR			szReturnReceipt[] = "Sender: %s\n\nSubject: %s\n\nReceived: %s\n\n%s";
TCHAR			szTabChar[] = "\t";
BOOL			bNoTextClr = TRUE;
TCHAR			szMapiInfo[] = "%s%s";
LPCTSTR			lpCompose640 = "COMPOSENOTE640";
LPCTSTR			lpCompose800 = "COMPOSENOTE800";
LPCTSTR			lpCompose1024 = "COMPOSENOTE1024";
LPCTSTR			lpRead640 = "READMESSAGE640";
LPCTSTR			lpRead800 = "READMESSAGE800";
LPCTSTR			lpRead1024 = "READMESSAGE1024";

LPCTSTR			lpCompose640New = "COMPOSENOTE640NEW";
LPCTSTR			lpCompose800New = "COMPOSENOTE800NEW";
LPCTSTR			lpCompose1024New = "COMPOSENOTE1024NEW";
LPCTSTR			lpRead640New = "READMESSAGE640NEW";
LPCTSTR			lpRead800New = "READMESSAGE800NEW";
LPCTSTR			lpRead1024New = "READMESSAGE1024NEW";

// Event handles.
//...............
HANDLE			hComposeEvent;
HANDLE			hComposeOpen;
DWORD			dwComposeNote;
HANDLE			hInBoxEvent;
HANDLE			hInBoxOpen;
DWORD			dwInBox;
HANDLE			hReadEvent;
HANDLE			hReadOpen;
DWORD			dwReadBox;

PARAFORMAT2		pf;
CHARFORMAT2		cf;

int				iBullet;
int				iStyle;

// Pointer to the list of messages in the central directory.
// Max of 1,000.
//..........................................................
LPMSGID			lpMsgList;
LPMSGID			lpDelMsgDup;
int				iTotalMsgs;
HICON			hDelEmailIcon;
int				iMsgsSelected;
int				iDeleteMsgs;
LPINT			lpInt;
int				iFilesSelected;
HIMAGELIST		himlSmall;
BOOL			bMsgDecrypted;
TCHAR			szRR[] = "Your message was decrypted and read on sender's computer on %s at %s GMT.";
TCHAR			szRRND[] = "Your message was displayed, but not decrypted, on senders computer on %s at %s GMT.";

// Handle a return receipt request.
//.................................
VOID HandleReturnReciept(HWND hWnd)
{
	ULONG			ulResult;
	int				iResult;
	lpMapiMessage	lpReturnMsg = 0;
	TCHAR			szMsgID[1024];
	TCHAR			szQuestion[128];
	SYSTEMTIME		stGmtTime;
	TCHAR			szDate[128];
	TCHAR			szTime1[64];

	LoadString(hInst,IDS_RETURN_RECEIPT,szQuestion,sizeof(szQuestion));

	StringCbPrintf((LPTSTR)&szMsgID,sizeof(szMsgID),(LPCTSTR)&szReturnReceipt,
					lpReadMsgNode->lpszFrom,lpReadMsgNode->lpszSubject,
					lpReadMsg->lpszDateReceived,&szQuestion);

	// Ask if we really want to send a read receipt.
	//..............................................
	iResult = MessageBoxProc(hMainWindow,IDS_QUESTION,(UINT)&szMsgID,
							 MB_ICONQUESTION | MB_YESNO | MB_HELP,MB_ICONQUESTION,0);

	lpReadMsgNode->bReceiptRequested = FALSE;
	if (iResult == IDYES)
	{
		lpReturnMsg = (lpMapiMessage)PvAlloc(sizeof(MapiMessage));
		if (!lpReturnMsg)
		{
			goto HandleEnd;
		}
		ZeroMemory(lpReturnMsg,sizeof(MapiMessage));

		// Set the flags.
		//...............
		lpReturnMsg->flFlags = 0;

		// Setup the subject if we have one.
		//..................................
		if (lpReadMsg->lpszSubject)
		{
			lpReturnMsg->lpszSubject = (LPTSTR)PvAlloc(lstrlen(lpReadMsg->lpszSubject) + 10);
			if (!lpReturnMsg->lpszSubject)
			{
				goto HandleEnd;
			}
			StringCbCopy(lpReturnMsg->lpszSubject,(lstrlen(lpReadMsg->lpszSubject) + 10),
						 "RR: ");
			StringCbCat(lpReturnMsg->lpszSubject,(lstrlen(lpReadMsg->lpszSubject) + 10),
						lpReadMsg->lpszSubject);
		}
		// Setup the message type if there is one.
		//........................................
		if (lpReadMsg->lpszMessageType)
		{
			lpReturnMsg->lpszMessageType = (LPTSTR)PvAlloc(lstrlen(lpReadMsg->lpszMessageType) + 1);
			if (!lpReturnMsg->lpszMessageType)
			{
				goto HandleEnd;
			}
			StringCbCopy(lpReturnMsg->lpszMessageType,
						(lstrlen(lpReadMsg->lpszMessageType) + 1),lpReadMsg->lpszMessageType);
		}
		// Set the message conversation ID if there is one.
		//.................................................
		if (lpReadMsg->lpszConversationID)
		{
			lpReturnMsg->lpszConversationID = (LPTSTR)PvAlloc(lstrlen(lpReadMsg->lpszConversationID) + 1);
			if (!lpReturnMsg->lpszConversationID)
			{
				goto HandleEnd;
			}
			StringCbCopy(lpReturnMsg->lpszConversationID,
						(lstrlen(lpReadMsg->lpszConversationID) + 1),
						 lpReadMsg->lpszConversationID);
		}
		// Setup the recipient.
		//.....................
		if (lpReadMsg->lpOriginator)
		{
			lpReturnMsg->nRecipCount = 1;
		}
		else
		{
			goto HandleEnd;
		}
		lpReturnMsg->lpRecips = (lpMapiRecipDesc)PvAlloc(sizeof(MapiRecipDesc));
		if (!lpReturnMsg->lpRecips)
		{
			goto HandleEnd;
		}
		ZeroMemory(lpReturnMsg->lpRecips,sizeof(MapiRecipDesc));

		lpReadMsg->lpOriginator->ulRecipClass = MAPI_TO;
		CopyRecipient(lpReturnMsg->lpRecips,lpReturnMsg->lpRecips,lpReadMsg->lpOriginator);
		lpReadMsg->lpOriginator->ulRecipClass = MAPI_ORIG;

		// Setup the text of the message.
		//...............................
		GetSystemTime(&stGmtTime);
		ZeroMemory(&szDate,sizeof(szDate));
		ZeroMemory(&szTime1,sizeof(szTime1));
		ZeroMemory(&szMsgID,sizeof(szMsgID));

		GetDateFormat(LOCALE_USER_DEFAULT,DATE_LONGDATE,&stGmtTime,NULL,
					 (LPTSTR)&szDate,sizeof(szDate));
		GetTimeFormat(LOCALE_USER_DEFAULT,TIME_FORCE24HOURFORMAT,&stGmtTime,NULL,
					 (LPTSTR)&szTime1,sizeof(szTime1));
		// Send the appropriate message depending on if we decrypted the
		// message or not.
		//..............................................................
		if (bMsgDecrypted)
		{
			StringCbPrintf(szMsgID,sizeof(szMsgID),szRR,&szDate,&szTime1);
		}
		else
		{
			StringCbPrintf(szMsgID,sizeof(szMsgID),szRRND,&szDate,&szTime1);
		}
		lpReturnMsg->lpszNoteText = (LPTSTR)PvAlloc(lstrlen((LPCTSTR)&szMsgID) + 1);
		if (!lpReturnMsg->lpszNoteText)
		{
			goto HandleEnd;
		}
		StringCbCopy(lpReturnMsg->lpszNoteText,(lstrlen((LPCTSTR)&szMsgID) + 1),
					(LPCTSTR)&szMsgID);

		// Send the message.
		//..................
		ulResult = MAPISendMail(lHandle,(ULONG)hWnd,lpReturnMsg,MAPI_DIALOG,0);
		if (ulResult != SUCCESS_SUCCESS)
		{
			SetLastError(ulResult + MAPI_BASE);
			ErrorProcedure(lpMapiDllName,IDS_MAPI_SEND_MAIL,MB_OK);
		}
	}

	HandleEnd:

	if (lpReturnMsg)
	{
		PvFree(lpReturnMsg->lpszSubject);
		PvFree(lpReturnMsg->lpszNoteText);
		PvFree(lpReturnMsg->lpszMessageType);
		PvFree((LPBYTE)lpReturnMsg->lpszConversationID);
		PvFree((LPBYTE)lpReturnMsg->lpRecips);
		PvFree((LPBYTE)lpReturnMsg);
	}
}

// Read, decrypt, and save e-mail messages.
//.........................................
VOID DecryptMail()
{
	DWORD			dwOldHelpTopic;
	HANDLE			hRtf = 0;
	BOOL			bResult;
	BOOL			bErr;
	ULONG			idx;
	ULONG			ulResult;
	HWND			hInBox = 0;
	HWND			hCompose = 0;

	// We have a process in progress.
	//...............................
	bProcessInProgress = TRUE;

	// Change the help topic.
	//.......................
	dwOldHelpTopic = ChangeHelpTopic(IDH_DECRYPTEMAIL);

	lpMsgList = 0;
	bReplyToDecrypted = FALSE;

	if (BPC())
	{
		goto ReadEnd;
	}
	// Load the rich text edit dll.
	//.............................
	hRtf = LoadLibrary((LPCTSTR)&szMyRichEditCtrl);
	if (!hRtf)
	{
		ErrorProcedure((LPTSTR)&szMyRichEditCtrl,IDS_LOADLIBRARY,MB_OK);
		goto ReadEnd;
	}
	// If we are not logged onto MAPI, do so.
	//.......................................
	if (!bLoggedOn)
	{
		bResult = LogonToMapi(IDH_DECRYPTEMAIL,FALSE,FALSE);
		if (!bResult)
		{
			goto ReadEnd;
		}
	}
	else
	{
		// Since we may want to get new messages,
		// always log off and then log back on.
		//.......................................
		LogoffFromMapi(FALSE,FALSE);
		if (!bLoggedOn)
		{
			bResult = LogonToMapi(IDH_DECRYPTEMAIL,FALSE,FALSE);
			if (!bResult)
			{
				goto ReadEnd;
			}
		}
	}
	EmptyTheMessageQue();

	// Build a central directory of all the messages.
	//...............................................
	bErr = BuildMsgCentralDir();
	if (bErr)
	{
		goto ReadEnd;
	}
	// We have not deleted any messages.
	//..................................
	iDeleteMsgs = 0;

	// If we do not have any messages to view bail out.
	//.................................................
	if (iTotalMsgs <= 0)
	{
		MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_MAPI_NOMSGS,
					   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
		goto ReadEnd;
	}
	// Go into a loop where we can continuously decrypt and reply to messages.
	//........................................................................
	while(TRUE)
	{
		dwInBox = 0;

		// Create an event for our in box.
		//................................
		hInBoxEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("InBoxEvent"));
		if (!hInBoxEvent)
		{
			ErrorProcedure(TEXT("InBoxEvent"),IDS_CREATEEVENT,MB_OK);
			goto ReadEnd;
		}
		// Display the dialog box that lists all of the messages in the Inbox.
		//....................................................................
		hInBox = CreateDialog(hInst,TEXT("INBOX"),hMainWindow,(DLGPROC)InBoxProc);
		if (hInBox == NULL)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto ReadEnd;
		}
		// Open our event and wait.
		//.........................
		hInBoxOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("InBoxEvent"));
		if (!hInBoxOpen)
		{
			DestroyWindow(hInBox);
			goto ReadEnd;
		}
		// Wait for the event to become signaled before we continue.
		//..........................................................
		while(TRUE)
		{
			if (WaitForSingleObject(hInBoxEvent,0) == WAIT_OBJECT_0)
			{
				break;
			}
			EmptyTheMessageQue();
		}
		// Check out the return results.
		//..............................
		if (dwInBox == IDCANCEL)
		{
			goto ReadEnd;
		}
		else
		{
			if (hInBoxOpen)
			{
				CloseHandle(hInBoxOpen);
				hInBoxOpen = 0;
			}
			if (hInBoxEvent)
			{
				CloseHandle(hInBoxEvent);
				hInBoxEvent = 0;
			}
		}
		// If we fall through to here it means we have to encrypt the contents.
		//.....................................................................
		bErr = EncryptAnEmailMessage();

		if (!bErr)
		{
			EmptyTheMessageQue();

			ulResult = MAPISendMail(lHandle,(ULONG)hMainWindow,lpmsg,MAPI_DIALOG,0);

			EmptyTheMessageQue();

			if (ulResult)
			{
				SetLastError(ulResult + MAPI_BASE);
				ErrorProcedure(lpMapiDllName,IDS_MAPI_SEND_MAIL,MB_OK);
			}
		}
		// We have to delete lpmsg if we had an error or not.
		//...................................................
		if(lpmsg)
		{
			PvFree(lpmsg->lpszSubject);
			PvFree(lpmsg->lpszNoteText);
			PvFree(lpmsg->lpszMessageType);
			PvFree((LPBYTE)lpmsg->lpszConversationID);
			PvFree((LPBYTE)lpmsg->lpRecips);
			PvFree((LPBYTE)lpmsg->lpFiles);
			PvFree((LPBYTE)lpmsg);
			lpmsg = NULL;
		}
		// We have everthing sent or we cancelled. Check lpReadMsg to see if
		// we have anything to delete like temp files etc.
		//..................................................................
		if (lpReadMsg)
		{
			// If there were file attachments, then delete the temps.
			//.......................................................
			for (idx = 0; idx < lpReadMsg->nFileCount; idx++)
			{
				if (lpReadMsg->lpFiles[idx].lpszPathName)
				{
					DeleteMyFile((LPTSTR)lpReadMsg->lpFiles[idx].lpszPathName);
				}
			}
			MAPIFreeBuffer(lpReadMsg);
			lpReadMsg = NULL;
		}
	}

	ReadEnd:

	if (hInBoxOpen)
	{
		CloseHandle(hInBoxOpen);
		hInBoxOpen = 0;
	}
	if (hInBoxEvent)
	{
		CloseHandle(hInBoxEvent);
		hInBoxEvent = 0;
	}
	if (hComposeOpen)
	{
		CloseHandle(hComposeOpen);
		hComposeOpen = 0;
	}
	if (hComposeEvent)
	{
		CloseHandle(hComposeEvent);
		hComposeEvent = 0;
	}
	if (hRtf)
	{
		FreeLibrary(hRtf);
	}
	if (lpMsgList)
	{
		// Delete selected messages.
		//..........................
		if (iDeleteMsgs)
		{
			DeleteMsgs();
		}
		// Delete the message list.
		//.........................
		if (iTotalMsgs > 0)
		{
			// Delete the fields in the message list for each message.
			//........................................................
			DeleteMsgListItems();
		}
		// Now delete the directory.
		//..........................
		ZeroMemory(lpMsgList,sizeof(MSGID) * MAX_MSGS);
		DeallocateMemory(lpMsgList);
		lpMsgList = 0;
	}
	iTotalMsgs = 0;
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for displaying the contents of the inbox.
//.............................................................
LRESULT CALLBACK InBoxProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	LPMSGID			lpMsgDup;
	int				i;
	DWORD			dwSizeMsgId = sizeof(MSGID);
	LPCTSTR			lpDialogBox;
	HWND			hReadBox = 0;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			LVCOLUMN		lvColumn;
			HWND			hWndListView1;
			HICON			hIcon;
			WORD			wIcon;
			TCHAR			szColumns[3][10] = {TEXT("From"),
											   TEXT("Subject"),
											   TEXT("Received")};

			int				iColumnSize[3] = {200,250,120};

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Get the window handle for the list view control.
			//.................................................
			hWndListView1 = GetDlgItem(hDlg,IDC_MSGLIST);

			// Set the extended styles for the list view window.
			//..................................................
			ListView_SetExtendedListViewStyleEx(hWndListView1,0,LVS_EX_FULLROWSELECT |
										        LVS_EX_ONECLICKACTIVATE |
										        LVS_EX_UNDERLINEHOT | LVS_EX_GRIDLINES);

			// Set the header columns for the virtual list view window.
			//.........................................................
			lvColumn.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
			lvColumn.fmt = LVCFMT_LEFT;
			for (i = 0; i < 3; i++)
			{
				lvColumn.pszText = szColumns[i];
				lvColumn.cx = iColumnSize[i];
				SendMessage(hWndListView1,LVM_INSERTCOLUMN,(WPARAM)i,(LPARAM)&lvColumn);
			}
			// Empty the list.
			//................
			SendMessage(hWndListView1,LVM_DELETEALLITEMS,0,0);

			// Create the image list for the control.
			//.......................................
			himlSmall = ImageList_Create(16,16,ILC_MASK,ICONS_MAX,0);
			
			if (himlSmall)
			{
				// Load the icons to use for the messages.
				//........................................
				wIcon = ICON_BASE;

				for (i = 0; i < ICONS_MAX; i++)
				{
					hIcon = LoadImage(hInst,MAKEINTRESOURCE(wIcon),IMAGE_ICON,16,16,
									  LR_VGACOLOR);
					ImageList_AddIcon(himlSmall,hIcon);
					DestroyIcon(hIcon);
					wIcon++;
				}
				ListView_SetImageList(hWndListView1,himlSmall,LVSIL_SMALL);
			}
			// Set the number of items in the list.
			//.....................................
			SendMessage(hWndListView1,LVM_SETITEMCOUNT,(WPARAM)iTotalMsgs, 
					   (LPARAM)LVSICF_NOINVALIDATEALL);

			// Set the callback mask so we can control the state information.
			//...............................................................
			SendMessage(hWndListView1,LVM_SETCALLBACKMASK,
					   (WPARAM)LVIS_SELECTED | LVIS_FOCUSED,0);

			SetCursor(hOldCur);
			SetFocus(hWndListView1);

			// If we have any items selected, set the command buttons as needed.
			//..................................................................
			if (iMsgsSelected)
			{
				// Find the selected item and mark it for deletion.
				//.................................................
				for (i = 0; i < iTotalMsgs; i++)
				{
					__asm
					{
						mov		eax,i
						mov		ecx,dwSizeMsgId
						mul		ecx
						add		eax,lpMsgList
						mov		lpMsgDup,eax
					}
					if (lpMsgDup->State & LVIS_SELECTED)
					{
						break;
					}
				}
				EnableWindow(GetDlgItem(hDlg,IDC_READMSG),TRUE);

				if (lpMsgDup->bDeleteMsg)
				{
					EnableWindow(GetDlgItem(hDlg,IDC_DELETEMSG),FALSE);
					EnableWindow(GetDlgItem(hDlg,IDC_UNDELETEMSG),TRUE);
				}
				else
				{
					EnableWindow(GetDlgItem(hDlg,IDC_DELETEMSG),TRUE);
					EnableWindow(GetDlgItem(hDlg,IDC_UNDELETEMSG),FALSE);
				}
			}
			// Center the dialog box.
			//.......................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return FALSE;
		}
		
		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_DELETEMSG:
				{
					// Find the selected item and mark it for deletion.
					//.................................................
					for (i = 0; i < iTotalMsgs; i++)
					{
						__asm
						{
							mov		eax,i
							mov		ecx,dwSizeMsgId
							mul		ecx
							add		eax,lpMsgList
							mov		lpMsgDup,eax
						}
						if (lpMsgDup->State & LVIS_SELECTED)
						{
							break;
						}
					}
					if (lpMsgDup->bDeleteMsg == FALSE)
					{
						lpMsgDup->bDeleteMsg = TRUE;
						SendDlgItemMessage(hDlg,IDC_MSGLIST,LVM_UPDATE,(WPARAM)i,0);
						iDeleteMsgs++;
					}
					EnableWindow(GetDlgItem(hDlg,IDC_DELETEMSG),FALSE);
					EnableWindow(GetDlgItem(hDlg,IDC_UNDELETEMSG),TRUE);
					SetFocus(GetDlgItem(hDlg,IDC_MSGLIST));
				}
				break;

				case IDC_UNDELETEMSG:
				{
					// Find the selected item and mark it as not deleted.
					//...................................................
					for (i = 0; i < iTotalMsgs; i++)
					{
						__asm
						{
							mov		eax,i
							mov		ecx,dwSizeMsgId
							mul		ecx
							add		eax,lpMsgList
							mov		lpMsgDup,eax
						}
						if (lpMsgDup->State & LVIS_SELECTED)
						{
							break;
						}
					}
					if (lpMsgDup->bDeleteMsg == TRUE)
					{
						lpMsgDup->bDeleteMsg = FALSE;
						SendDlgItemMessage(hDlg,IDC_MSGLIST,LVM_UPDATE,(WPARAM)i,0);
						iDeleteMsgs--;
					}
					EnableWindow(GetDlgItem(hDlg,IDC_DELETEMSG),TRUE);
					EnableWindow(GetDlgItem(hDlg,IDC_UNDELETEMSG),FALSE);
					SetFocus(GetDlgItem(hDlg,IDC_MSGLIST));
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
					SetFocus(GetDlgItem(hDlg,IDC_MSGLIST));
				}
				break;

				case IDC_READMSG:
				{
					// Find the currently selected message to read.
					//.............................................
					for (i = 0; i < iTotalMsgs; i++)
					{
						__asm
						{
							mov		eax,i
							mov		ecx,dwSizeMsgId
							mul		ecx
							add		eax,lpMsgList
							mov		lpReadMsgNode,eax
						}
						if (lpReadMsgNode->State & LVIS_SELECTED)
						{
							break;
						}
					}
					if (lpReadMsgNode->State & LVIS_SELECTED)
					{
						// Disable our dialog box.
						//........................
						ShowWindow(hDlg,SW_HIDE);
						EnableWindow(hDlg,FALSE);
						dwReadBox = 0;

						// Create an event for our read message box.
						//..........................................
						hReadEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("ReadEvent"));
						if (!hReadEvent)
						{
							ErrorProcedure(TEXT("ReadEvent"),IDS_CREATEEVENT,MB_OK);
							goto BackToInBox;
						}
						// Determine the current display resolution.
						//..........................................
						i = GetSystemMetrics(SM_CXFULLSCREEN);

						// Display the dialog box to read a message with depending
						// on the current screen resolution.
						//........................................................
						if (bHaveRichEdit41orGreater)
						{
							if (i >= 950)
							{
								lpDialogBox = lpRead1024New;
							}
							else if (i >= 750)
							{
								lpDialogBox = lpRead800New;
							}
							else
							{
								lpDialogBox = lpRead640New;
							}
						}
						else
						{
							if (i >= 950)
							{
								lpDialogBox = lpRead1024;
							}
							else if (i >= 750)
							{
								lpDialogBox = lpRead800;
							}
							else
							{
								lpDialogBox = lpRead640;
							}
						}
						hReadBox = CreateDialog(hInst,lpDialogBox,hMainWindow,
											   (DLGPROC)ReadMessageProc);

						if (hReadBox == NULL)
						{
							ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
							goto BackToInBox;
						}
						// We have to wait for the reply from the read message box.
						//.........................................................
						hReadOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("ReadEvent"));
						if (!hReadOpen)
						{
							DestroyWindow(hReadBox);
							goto BackToInBox;
						}
						while(TRUE)
						{
							if (WaitForSingleObject(hReadEvent,0) == WAIT_OBJECT_0)
							{
								break;
							}
							EmptyTheMessageQue();
						}
						// Delete the rich text edit file if we have one.
						//...............................................
						if (bDeleteReplyFile)
						{
							WipeMyFile((LPBYTE)&szMyReplyFile,TRUE);
							bDeleteReplyFile = FALSE;
						}
						if (hReadOpen)
						{
							CloseHandle(hReadOpen);
							hReadOpen = 0;
						}
						if (hReadEvent)
						{
							CloseHandle(hReadEvent);
							hReadEvent = 0;
						} 
						// If we fall back through here with IDC_MSGENCRYPT
						// we have to destroy the dialog box and encrypt the
						// reply.
						//...................................................
						if (dwReadBox == IDC_MSGENCRYPT)
						{
							ImageList_Destroy(himlSmall);
							SendMessage(GetDlgItem(hDlg,IDC_MSGLIST),LVM_DELETEALLITEMS,0,0);
							dwInBox = IDC_MSGENCRYPT;
							DestroyWindow(hDlg);
						}
						
					  BackToInBox:

						if (hReadOpen)
						{
							CloseHandle(hReadOpen);
							hReadOpen = 0;
						}
						if (hReadEvent)
						{
							CloseHandle(hReadEvent);
							hReadEvent = 0;
						}
						// Enable our dialog box.
						//.......................
						EnableWindow(hDlg,TRUE);
						ShowWindow(hDlg,SW_SHOW);
					}
					SetFocus(GetDlgItem(hDlg,IDC_MSGLIST));
				}
				break;

				case IDCANCEL:
				{
					iDeleteMsgs = 0;
				}
				case IDC_MYCLOSE:
				{
					ImageList_Destroy(himlSmall);
					SendMessage(GetDlgItem(hDlg,IDC_MSGLIST),LVM_DELETEALLITEMS,0,0);
					dwInBox = IDCANCEL;
					DestroyWindow(hDlg);
				}
				break;
			}
		}
		break;

		case WM_SYSCOLORCHANGE:
		{
			ListView_SetBkColor(GetDlgItem(hDlg,IDC_MSGLIST),GetSysColor(COLOR_WINDOW));			
		}
		break;

		case WM_NOTIFY:
		{
			return(MsgListNotify(hDlg,(LPNMHDR)lParam));
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_DESTROY:
		{
			// Notify the compose note procedure that it can
			// continue.
			//..............................................
			SetEvent(hInBoxEvent);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Handle the WM_NOTIFY message for the virtual list view window
// while viewing the contents of our inbox.
//..............................................................
LRESULT MsgListNotify(HWND hDlg, LPNMHDR lpNmhdr)
{
	LPNMLVDISPINFO		lpLvdi;
	LPMSGID				lpMsgDup;
	int					iIndex;
	DWORD				dwScratch;
	DWORD				dwSizeMsg = sizeof(MSGID);
	LPNMLISTVIEW		lpnmListView;
	BOOL				bCtrlKey;
	BOOL				bAltKey;
	BOOL				bShiftKey;
	int					i;
	SHORT				sTemp;

	bCtrlKey = FALSE;
	bAltKey = FALSE;
	bShiftKey = FALSE;

	// Determine the keys pressed during the selection.
	//.................................................
	sTemp = GetKeyState(VK_CONTROL);
	if (sTemp & 0x8000)
	{
		bCtrlKey = TRUE;
	}
	sTemp = GetKeyState(VK_SHIFT);
	if (sTemp & 0x8000)
	{
		bShiftKey = TRUE;
	}
	sTemp = GetKeyState(VK_MENU);
	if (sTemp & 0x8000)
	{
		bAltKey = TRUE;
	}

	switch (lpNmhdr->code)
	{
		case LVN_GETDISPINFO:
		{
			lpLvdi = (LPNMLVDISPINFO)lpNmhdr;

			// Get the index of the msg structure.
			//....................................
			iIndex = lpLvdi->item.iItem;
			lpMsgDup = lpMsgList;
			dwScratch = iIndex * dwSizeMsg;
			__asm
			{
				mov		eax,dwScratch
				add		lpMsgDup,eax
			}
			// Fill in the image information for the first column.
			//....................................................
			if (lpLvdi->item.mask & LVIF_IMAGE)
			{
				if (lpMsgDup->bDeleteMsg)
				{
					lpLvdi->item.iImage = 8;
				}
				else
				{
					lpLvdi->item.iImage = lpMsgDup->iImageIdx;
				}
			}
			// Fill in the items state.
			//.........................
			if (lpLvdi->item.mask & LVIF_STATE)
			{
				lpLvdi->item.state = lpMsgDup->State;
			}
			// Fill in the text for the item and subitems.
			//............................................
			if (lpLvdi->item.mask & LVIF_TEXT)
			{
				switch(lpLvdi->item.iSubItem)
				{
					case 0:
					{
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)lpMsgDup->lpszFrom);
					}
					break;

					case 1:
					{
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
								    (LPCTSTR)lpMsgDup->lpszSubject);
					}
					break;

					case 2:
					{
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)lpMsgDup->lpszDateRec);
					}
					break;
				}
			}
		}
		break;

		// Handle left mouse button clicks.
		//.................................
		case NM_CLICK:
		{
			lpnmListView = (LPNMLISTVIEW)lpNmhdr;

			// Determine the index of the item.
			//.................................
			iIndex = lpnmListView->iItem;

			// Check to see if we have a click on an invalid area.
			//....................................................
			if (iIndex == -1)
			{
				// Unmark all the items and set the first selectable item
				// as focused.
				//.......................................................
				for (i = 0; i < iTotalMsgs; i++)
				{
					__asm
					{
						mov		eax,i
						mov		ecx,dwSizeMsg
						mul		ecx
						add		eax,lpMsgList
						mov		lpMsgDup,eax
					}
					if (lpMsgDup->State)
					{
						lpMsgDup->State = 0;
						SendDlgItemMessage(hDlg,IDC_MSGLIST,LVM_UPDATE,(WPARAM)i,0);
					}
				}
				// Set the focus on the first item that can be selected.
				//......................................................
				lpMsgList->State = LVIS_FOCUSED;
				SendDlgItemMessage(hDlg,IDC_MSGLIST,LVM_UPDATE,0,0);
				iMsgsSelected = 0;
			}
			else
			{
				// Find the item with the focus or selected and focused.
				//......................................................
				for (i = 0; i < iTotalMsgs; i++)
				{
					__asm
					{
						mov		eax,i
						mov		ecx,dwSizeMsg
						mul		ecx
						add		eax,lpMsgList
						mov		lpMsgDup,eax
					}
					if (lpMsgDup->State)
					{
						break;
					}
				}
				if (bCtrlKey && bAltKey)
				{
					// Unmark the selection and place the focus on the first item.
					//............................................................
					lpMsgDup->State = 0;
					SendDlgItemMessage(hDlg,IDC_MSGLIST,LVM_UPDATE,(WPARAM)i,0);
					i = 0;
					lpMsgList->State = LVIS_FOCUSED;
					SendDlgItemMessage(hDlg,IDC_MSGLIST,LVM_UPDATE,(WPARAM)i,0);
					iMsgsSelected = 0;
				}
				else if (i == iIndex && bCtrlKey)
				{
					// Toggle the state of the item.
					//..............................
					lpMsgDup->State ^= LVIS_SELECTED;
					SendDlgItemMessage(hDlg,IDC_MSGLIST,LVM_UPDATE,(WPARAM)i,0);
					if (iMsgsSelected == 0)
					{
						iMsgsSelected = 1;
					}
					else
					{
						iMsgsSelected = 0;
					}
				}
				// If the shift or just alt keys are pressed, skip them.
				//......................................................
				else if (bShiftKey || bAltKey)
				{
					break;
				}
				else
				{
					// Normal selection. Unselect and unfocus the selected item.
					//..........................................................
					for (i = 0; i < iTotalMsgs; i++)
					{
						__asm
						{
							mov		eax,i
							mov		ecx,dwSizeMsg
							mul		ecx
							add		eax,lpMsgList
							mov		lpMsgDup,eax
						}
						if (lpMsgDup->State)
						{
							lpMsgDup->State = 0;
							SendDlgItemMessage(hDlg,IDC_MSGLIST,LVM_UPDATE,(WPARAM)i,0);
							break;
						}
					}
					// Mark the newly selected item as selected and focused.
					//......................................................
					iMsgsSelected = 1;

					__asm
					{
						mov		eax,iIndex
						mov		ecx,dwSizeMsg
						mul		ecx
						add		eax,lpMsgList
						mov		lpMsgDup,eax
					}
					lpMsgDup->State = (LVIS_SELECTED | LVIS_FOCUSED);
					SendDlgItemMessage(hDlg,IDC_MSGLIST,LVM_UPDATE,(WPARAM)iIndex,0);
				}
			}
			if (iMsgsSelected)
			{
				__asm
				{
					mov		eax,iIndex
					mov		ecx,dwSizeMsg
					mul		ecx
					add		eax,lpMsgList
					mov		lpMsgDup,eax
				}
				EnableWindow(GetDlgItem(hDlg,IDC_READMSG),TRUE);

				if (lpMsgDup->bDeleteMsg)
				{
					EnableWindow(GetDlgItem(hDlg,IDC_DELETEMSG),FALSE);
					EnableWindow(GetDlgItem(hDlg,IDC_UNDELETEMSG),TRUE);
				}
				else
				{
					EnableWindow(GetDlgItem(hDlg,IDC_DELETEMSG),TRUE);
					EnableWindow(GetDlgItem(hDlg,IDC_UNDELETEMSG),FALSE);
				}
			}
			else
			{
				// Disable the read, delete, and undelete buttons.
				//................................................
				EnableWindow(GetDlgItem(hDlg,IDC_READMSG),FALSE);
				EnableWindow(GetDlgItem(hDlg,IDC_DELETEMSG),FALSE);
				EnableWindow(GetDlgItem(hDlg,IDC_UNDELETEMSG),FALSE);
			}
		}
		break;

		// These two messages are not currently used by the program.
		//..........................................................
		case LVN_ODCACHEHINT:
        case LVN_ODFINDITEM:
			break;

		default:
			break;
	}
	return(0);
}

// CALLBACK procedure for reading the contents of a message.
//..........................................................
LRESULT CALLBACK ReadMessageProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	ULONG			ulResult;
	ULONG			idx;
	LPTSTR			lpFileName;
	BOOL			bErr;
	BOOL			bResult;
	int				i;
	LPCTSTR			lpDialogBox;
	HWND			hCompose = 0;
	
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Setup the rich text edit control.
			//..................................
			SendDlgItemMessage(hDlg,IDC_RNOTE,EM_AUTOURLDETECT,(WPARAM)TRUE,0);
			SendDlgItemMessage(hDlg,IDC_RNOTE,EM_SETEVENTMASK,0,ENM_LINK);

			SendDlgItemMessage(hDlg,IDC_RATTACHMENT,LB_SETHORIZONTALEXTENT,(WPARAM)350,0);

			// Setup ole callback.
			//....................
			SetupOleCallback(hDlg,IDC_RNOTE);

			// Get the message.
			//.................
			if (ulResult = MAPIReadMail(lHandle,(LONG)hDlg,lpReadMsgNode->lpszMsgID,
										0,0,&lpReadMsg))
			{
				SetLastError(ulResult + MAPI_BASE);
				ErrorProcedure(lpMapiDllName,IDS_MAPI_READ_MAIL,MB_OK);
				DestroyWindow(hDlg);
				return(TRUE);
			}
			if (lpReadMsgNode->bUnRead)
			{
				lpReadMsgNode->bUnRead = FALSE;
				lpReadMsgNode->iImageIdx++;
			}
			szDisplayNames[0] = '\0';
			szUnResNames[0] = '\0';
			szBcc[0] = '\0';

			for (idx = 0; idx < lpReadMsg->nRecipCount; idx++)
			{
				if (lpReadMsg->lpRecips[idx].ulRecipClass == MAPI_TO)
				{
					StringCbCatEx(szDisplayNames,TO_EDIT_MAX,
								  lpReadMsg->lpRecips[idx].lpszName,NULL,NULL,
								  dwStringSafeFlag);
					StringCbCatEx(szDisplayNames,TO_EDIT_MAX,"; ",NULL,NULL,
								  dwStringSafeFlag);
				}
				else if (lpReadMsg->lpRecips[idx].ulRecipClass == MAPI_CC)
				{
					StringCbCatEx(szUnResNames,CC_EDIT_MAX,lpReadMsg->lpRecips[idx].lpszName,
								  NULL,NULL,dwStringSafeFlag);
					StringCbCatEx(szUnResNames,CC_EDIT_MAX,"; ",NULL,NULL,dwStringSafeFlag);
				}
			}
			if(*szDisplayNames)
			{
				szDisplayNames[lstrlen(szDisplayNames) - 2] = '\0';
			}
			if(*szUnResNames)
			{
				szUnResNames[lstrlen(szUnResNames) - 2] = '\0';
			}
			// Setup the text for the various fields.
			//.......................................
			SetDlgItemText(hDlg,IDC_RFROM,
						  (lpReadMsg->lpOriginator && lpReadMsg->lpOriginator->lpszName ?
						   lpReadMsg->lpOriginator->lpszName : ""));

			SetDlgItemText(hDlg,IDC_RDATE,
						  (lpReadMsg->lpszDateReceived ? lpReadMsg->lpszDateReceived : ""));

			SetDlgItemText(hDlg,IDC_RTO,szDisplayNames);
			SetDlgItemText(hDlg,IDC_RCC,szUnResNames);
			SetDlgItemText(hDlg,IDC_RSUBJECT,
						  (lpReadMsg->lpszSubject ? lpReadMsg->lpszSubject : ""));

			bResult = SetDlgItemText(hDlg,IDC_RNOTE,
								    (lpReadMsg->lpszNoteText ? lpReadMsg->lpszNoteText : ""));
			if (!bResult)
			{
				// We probably had a memory error.
				//................................
				ErrorProcedure(lpszRTF,IDS_SETDLGITEMTEXT,MB_OK);
			}

			if (!lpReadMsg->nFileCount)
			{
				EnableWindow(GetDlgItem(hDlg,IDC_SAVEATTACH),FALSE);
				EnableWindow(GetDlgItem(hDlg,IDC_RATTACHMENT),FALSE);
			}
			else
			{
				for(idx = 0; idx < lpReadMsg->nFileCount; idx++)
				{
					if (lpReadMsg->lpFiles[idx].lpszFileName)
					{
						lpFileName = PathFindFileName((LPCTSTR)lpReadMsg->lpFiles[idx].lpszFileName);
						SendDlgItemMessage(hDlg,IDC_RATTACHMENT,LB_ADDSTRING,0,
										  (LPARAM)lpFileName);
					}
				}
				SendDlgItemMessage(hDlg,IDC_RATTACHMENT,LB_SETCURSEL,0,0L);
			}
			// If this is an encrypted message enable decrypt button.
			//.......................................................
			if (lpReadMsgNode->bEncrypted)
			{
				EnableWindow(GetDlgItem(hDlg,IDC_RDECRYPT),TRUE);
			}
			bSaveAsText = TRUE;

			// Center the dialog box.
			//.......................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDC_RNOTE));
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_RDECRYPT:
				{
					// Decrypt the message in lpReadMsg. Place the decrypted
					// contents in the rich text edit control.
					//......................................................
					bMsgDecrypted = FALSE;

					// Disable out dialog box.
					//........................
					EnableWindow(hDlg,FALSE);

					bErr = DecryptTheMessage(hDlg);

					// Handle a return receipt request.
					//.................................
					if (lpReadMsgNode->bReceiptRequested)
					{
						if (!bErr)
						{
							bMsgDecrypted = TRUE;
						}
						HandleReturnReciept(hDlg);
					}
					if (!bErr)
					{
						EnableWindow(GetDlgItem(hDlg,IDC_RDECRYPT),FALSE);
						bSaveAsText = FALSE;
					}
					else
					{	
						// We had an error, reset the original encrypted text.
						//....................................................
						SetDlgItemText(hDlg,IDC_RNOTE,
									  (lpReadMsg->lpszNoteText ? lpReadMsg->lpszNoteText : ""));
					}
					// Enable our dialog box.
					//.......................
					EnableWindow(hDlg,TRUE);
					SetFocus(GetDlgItem(hDlg,IDC_REPLY));
				}
				break;

				case IDC_SAVEATTACH:
				{
					iFilesSelected = SendDlgItemMessage(hDlg,IDC_RATTACHMENT,
									                    LB_GETSELCOUNT,0,0L);
					if (iFilesSelected > 0)
					{
						// Disable the dialog box.
						//........................
						EnableWindow(hDlg,FALSE);

						// Allocate memory for the list of identifier integers.
						//.....................................................
						lpInt = AllocateMemory(iFilesSelected * sizeof(int));
						if (lpInt)
						{
							// Get the index numbers to the file selections.
							//..............................................
							SendDlgItemMessage(hDlg,IDC_RATTACHMENT,LB_GETSELITEMS,
											   iFilesSelected,(LPARAM)lpInt);

							SaveFileAttachments(hDlg);
							if (lpInt)
							{
								DeallocateMemory(lpInt);
								lpInt = 0;
							}
							SendDlgItemMessage(hDlg,IDC_RATTACHMENT,LB_SETSEL,FALSE,-1);
							
							// Enable our dialog box.
							//.......................
							EnableWindow(hDlg,TRUE);
						}
					}
					else
					{
						// No file attachments selected.
						//..............................
						MessageBoxProc(hDlg,IDS_ADVISORY,IDS_NO_FILE_ATTACH,
									   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
					}
					SetFocus(GetDlgItem(hDlg,IDC_REPLY));
				}
				break;

				case IDC_REPLY:
				case IDC_REPLYALL:
				case IDC_FORWARD:
				{
					// Setup and call ComposeNote dialog box.
					//.......................................
					bErr = MakeNewMessage(lpReadMsg,LOWORD(wParam));

					if (!bErr)
					{
						// Disable our dialog box.
						//........................
						ShowWindow(hDlg,SW_HIDE);
						EnableWindow(hDlg,FALSE);

						// Create an event for our compose e-mail message dialog box.
						//...........................................................
						hComposeEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("ComposeEvent"));
						if (!hComposeEvent)
						{
							ErrorProcedure(TEXT("ComposeEvent"),IDS_CREATEEVENT,MB_OK);
							break;
						}
						// Get the current screen size so we can display the correct
						// dialog box.
						//..........................................................
						i = GetSystemMetrics(SM_CXFULLSCREEN);

						if (bHaveRichEdit41orGreater)
						{
							if (i >= 950)
							{
								lpDialogBox = lpCompose1024New;
							}
							else if (i >= 750)
							{	
								lpDialogBox = lpCompose800New;
							}
							else
							{
								lpDialogBox = lpCompose640New;
							}
						}
						else
						{			
							if (i >= 950)
							{
								lpDialogBox = lpCompose1024;
							}
							else if (i >= 750)
							{	
								lpDialogBox = lpCompose800;
							}
							else
							{
								lpDialogBox = lpCompose640;
							}
						}
						hCompose = CreateDialog(hInst,lpDialogBox,hMainWindow,
											   (DLGPROC)ComposeNoteProc);
						if (hCompose == NULL)
						{
							ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
							goto BackToReadBox;
						}
						EmptyTheMessageQue();

						// Open our event and wait.
						//.........................
						hComposeOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("ComposeEvent"));
						if (!hComposeOpen)
						{
							DestroyWindow(hCompose);
							goto BackToReadBox;
						}
						while(TRUE)
						{
							if (WaitForSingleObject(hComposeEvent,0) == WAIT_OBJECT_0)
							{
								break;
							}
							EmptyTheMessageQue();
						}
						if (hComposeOpen)
						{
							CloseHandle(hComposeOpen);
							hComposeOpen = 0;
						}
						if (hComposeEvent)
						{
							CloseHandle(hComposeEvent);
							hComposeEvent = 0;
						}
						if (dwComposeNote == IDCANCEL)
						{
							dwComposeNote = 0;
							goto BackToReadBox;
						}
						// If we exit ComposeNote with IDC_MSGENCRYPT, we have to
						// bail out to encrypt the message.
						//.......................................................
						if (dwComposeNote == IDC_MSGENCRYPT)
						{
							// Set all of the text boxes in the dialog box to empty strings.
							//..............................................................
							SetDlgItemText(hDlg,IDC_RFROM,(LPCTSTR)lpszNullString);
							SetDlgItemText(hDlg,IDC_RDATE,(LPCTSTR)lpszNullString);
							SetDlgItemText(hDlg,IDC_RTO,(LPCTSTR)lpszNullString);
							SetDlgItemText(hDlg,IDC_RCC,(LPCTSTR)lpszNullString);
							SetDlgItemText(hDlg,IDC_RBCC,(LPCTSTR)lpszNullString);
							SetDlgItemText(hDlg,IDC_RSUBJECT,(LPCTSTR)lpszNullString);
							SendDlgItemMessage(hDlg,IDC_RATTACHMENT,LB_RESETCONTENT,0,0);
							SendDlgItemMessage(hDlg,IDC_RNOTE,WM_SETTEXT,0,
											  (LPARAM)lpszNullString);
							bDeleteReplyFile = FALSE;
							dwReadBox = IDC_MSGENCRYPT;
							dwComposeNote = 0;
							DestroyWindow(hDlg);
							break;
						}
					}
				  BackToReadBox:

					SetupOleCallback(hDlg,IDC_RNOTE);

					if (hComposeOpen)
					{
						CloseHandle(hComposeOpen);
						hComposeOpen = 0;
					}
					if (hComposeEvent)
					{
						CloseHandle(hComposeEvent);
						hComposeEvent = 0;
					}
					ShowWindow(hDlg,SW_SHOW);
					EnableWindow(hDlg,TRUE);
					SetFocus(GetDlgItem(hDlg,IDC_REPLY));
				}
				break;

				case IDC_MYCLOSE:
				case IDCANCEL:
				{	
					// If there were file attachments, then delete the temps.
					//.......................................................
					for (idx = 0; idx < lpReadMsg->nFileCount; idx++)
					{
						if (lpReadMsg->lpFiles[idx].lpszPathName)
						{
							DeleteMyFile((LPTSTR)lpReadMsg->lpFiles[idx].lpszPathName);
						}
					}
					MAPIFreeBuffer(lpReadMsg);
					lpReadMsg = NULL;
					dwReadBox = IDCANCEL;
					DestroyWindow(hDlg);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
		}
		break;

		case WM_NOTIFY:
		{
			LPENLINK	pEnlink;
			LPNMHDR		lpNmhdr;
			LPBYTE		lpLink;
			DWORD		dwLinkSize;
			CHARRANGE	range;

			pEnlink = (LPENLINK)lParam;
			lpNmhdr = (LPNMHDR)lParam;

			if (lpNmhdr->code == EN_LINK)
			{
				if (pEnlink->msg == WM_LBUTTONUP)
				{
					// Get the range and allocate the buffer.
					//.......................................
					dwLinkSize = pEnlink->chrg.cpMax - pEnlink->chrg.cpMin;
					if (dwLinkSize)
					{
						lpLink = AllocateMemory(dwLinkSize + 10);
						if (lpLink)
						{
							SetCursor(hCursorArrow);
							range.cpMax = pEnlink->chrg.cpMax;
							range.cpMin = pEnlink->chrg.cpMin;

							SendDlgItemMessage(hDlg,IDC_RNOTE,EM_EXSETSEL,0,
											  (LPARAM)(CHARRANGE FAR *)&range);
							SendDlgItemMessage(hDlg,IDC_RNOTE,EM_GETSELTEXT,0,(LPARAM)lpLink);
							ShellExecute(NULL,"open",(LPCTSTR)lpLink,NULL,NULL,SW_SHOWNORMAL);
							range.cpMin = -1;
							SendDlgItemMessage(hDlg,IDC_RNOTE,EM_EXSETSEL,0,
											  (LPARAM)(CHARRANGE FAR *)&range);
							DeallocateMemory(lpLink);
						}
					}
				}
			}
		}
		break;

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			HWND		hControl;
			
			hControl = GetDlgItem(hDlg,IDC_RNOTE);
			if (hControl == (HWND)wParam)
			{
				ReadContextMenu(hDlg,(HWND)wParam,lParam);
			}
			else
			{
				WhatsThis(hDlg,(HWND)wParam,lParam);
			}
		}
		break;

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_DESTROY:
		{
			// Notify the in box procedure that it can
			// continue.
			//........................................
			SetEvent(hReadEvent);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Delete selected messages.
//..........................
VOID DeleteMsgs()
{
	int				i;
	int				iResult;
	ULONG			ulResult;
	BOOL			bResult;
	DWORD			dwSizeMsgId = sizeof(MSGID);

	if (!bLoggedOn)
	{
		bResult = LogonToMapi(IDH_DECRYPTEMAIL,FALSE,FALSE);
		if (!bResult)
		{
			return;
		}
	}
	EmptyTheMessageQue();
	bSkipTheRest = FALSE;

	// Find the messages selected for deletion and delete them.
	//.........................................................
	for (i = 0; i < iTotalMsgs; i++)
	{
		__asm
		{
			mov		eax,i
			mov		ecx,dwSizeMsgId
			mul		ecx
			add		eax,lpMsgList
			mov		lpDelMsgDup,eax
		}
		if (lpDelMsgDup->bDeleteMsg)
		{
			if (!bSkipTheRest)
			{
				iResult = DialogBox(hInst,TEXT("CONFIRMDELETEEMAIL"),hMainWindow,
								   (DLGPROC)ConfirmDeleteEmailProc);

				if (iResult == IDCANCEL)
				{
					break;
				}
				if (iResult == IDC_MYNOE)
				{
					iDeleteMsgs--;
					continue;
				}
			}
			// We want to delete the message.
			//...............................
			ulResult = MAPIDeleteMail(lHandle,(ULONG)hMainWindow,lpDelMsgDup->lpszMsgID,0,0);
			if (ulResult != SUCCESS_SUCCESS)
			{
				SetLastError(ulResult + MAPI_BASE);
				ErrorProcedure(lpMapiDllName,IDS_MAPI_DEL_MAIL,MB_OK);
				break;
			}
			iDeleteMsgs--;

			if (hDelEmailIcon)
			{
				DestroyIcon(hDelEmailIcon);
				hDelEmailIcon = 0;
			}
		}
	}
	if (hDelEmailIcon)
	{
		DestroyIcon(hDelEmailIcon);
		hDelEmailIcon = 0;
	}
}

// CALLBACK procedure for asking confirmation on deleting email messages.
//.......................................................................
LRESULT CALLBACK ConfirmDeleteEmailProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	TCHAR		szBuffer[1024];

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use for the dialog box.
			//..........................................
			hDelEmailIcon = LoadImage(0,MAKEINTRESOURCE(IDI_QUESTION),IMAGE_ICON,32,32,
									  LR_SHARED);
			if (hDelEmailIcon)
			{
				SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hDelEmailIcon,0);
			}
			// Setup the from, subject, and date in the dialog box.
			//.....................................................
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),TEXT("From: %s"),
						    lpDelMsgDup->lpszFrom);
			SetDlgItemText(hDlg,IDC_EMAILFROM,(LPCTSTR)&szBuffer);

			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),TEXT("Subject: %s"),
						    lpDelMsgDup->lpszSubject);
			SetDlgItemText(hDlg,IDC_EMAILSUB,(LPCTSTR)&szBuffer);

			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),TEXT("Received: %s"),
							lpDelMsgDup->lpszDateRec);
			SetDlgItemText(hDlg,IDC_EMAILREC,(LPCTSTR)&szBuffer);

			// If we only have one file, disable the Yes to All button.
			//.........................................................
			if (iDeleteMsgs == 1)
			{
				EnableWindow(GetDlgItem(hDlg,IDC_YESTOALLE),FALSE);
			}
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}
	
		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{

				case IDC_MYYESE:
				{
					EndDialog(hDlg,IDC_MYYESE);
				}
				break;

				case IDC_YESTOALLE:
				{
					bSkipTheRest = TRUE;
					EndDialog(hDlg,IDC_YESTOALLE);
				}
				break;

				case IDC_MYNOE:
				{
					EndDialog(hDlg,IDC_MYNOE);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	
		default:
			return(FALSE);
	}
	return(TRUE);
}

// Compose, encrypt, and send e-mail messages in rich text format.
//................................................................
VOID EncryptMail()
{
	DWORD					dwOldHelpTopic;
	HANDLE					hRtf = 0;
	BOOL					bResult;
	ULONG					ulResult;
	BOOL					bErr;
	int						i;
	LPCTSTR					lpDialogBox;
	HWND					hCompose = 0;
	
	// We have a process in progress.
	//...............................
	bProcessInProgress = TRUE;

	// Change the help topic.
	//.......................
	dwOldHelpTopic = ChangeHelpTopic(IDH_ENCRYPTEMAIL);

	if (BPC())
	{
		goto MailEnd;
	}
	// Load the rich text edit dll.
	//.............................
	hRtf = LoadLibrary((LPCTSTR)&szMyRichEditCtrl);
	if (!hRtf)
	{
		ErrorProcedure((LPTSTR)&szMyRichEditCtrl,IDS_LOADLIBRARY,MB_OK);
		goto MailEnd;
	}
	// If we are not logged onto MAPI, do so.
	//.......................................
	if (!bLoggedOn)
	{
		bResult = LogonToMapi(IDH_ENCRYPTEMAIL,FALSE,FALSE);
		if (!bResult)
		{
			goto MailEnd;
		}
	}
	// Write messages until told to quit.
	//...................................
	while(TRUE)
	{
		dwComposeNote = 1;
		EmptyTheMessageQue();

		// Create an event for our compose e-mail message dialog box.
		//...........................................................
		hComposeEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("ComposeEvent"));
		if (!hComposeEvent)
		{
			ErrorProcedure(TEXT("ComposeEvent"),IDS_CREATEEVENT,MB_OK);
			goto MailEnd;
		}
		// Get the current screen size so we can display the correct
		// dialog box.
		//..........................................................
		i = GetSystemMetrics(SM_CXFULLSCREEN);

		if (bHaveRichEdit41orGreater)
		{
			if (i >= 950)
			{
				lpDialogBox = lpCompose1024New;
			}
			else if (i >= 750)
			{
				lpDialogBox = lpCompose800New;
			}
			else
			{
				lpDialogBox = lpCompose640New;
			}
		}
		else
		{
			if (i >= 950)
			{
				lpDialogBox = lpCompose1024;
			}
			else if (i >= 750)
			{
				lpDialogBox = lpCompose800;
			}
			else
			{
				lpDialogBox = lpCompose640;
			}
		}
		// Create the dialog box.
		//.......................
		hCompose = CreateDialog(hInst,lpDialogBox,hMainWindow,(DLGPROC)ComposeNoteProc);

		if (hCompose == NULL)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto MailEnd;
		}
		EmptyTheMessageQue();

		// Open our event and wait.
		//.........................
		hComposeOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("ComposeEvent"));
		if (!hComposeOpen)
		{
			DestroyWindow(hCompose);
			goto MailEnd;
		}
		// We have to wait for the Edit Event to become signaled before
		// we can return and process the selections from the Central
		// Directory.
		//.............................................................
		while(TRUE)
		{
			if (WaitForSingleObject(hComposeEvent,0) == WAIT_OBJECT_0)
			{
				break;
			}
			EmptyTheMessageQue();
		}
		if (hComposeOpen)
		{
			CloseHandle(hComposeOpen);
			hComposeOpen = 0;
		}
		if (hComposeEvent)
		{
			CloseHandle(hComposeEvent);
			hComposeEvent = 0;
		}
		if (dwComposeNote == 1 || dwComposeNote == IDCANCEL)
		{
			goto MailEnd;
		}
		// Here is where we encrypt the contents of the e-mail.
		// Setup the destination path.
		//.....................................................
		bErr = EncryptAnEmailMessage();

		if (bErr)
		{
			dwComposeNote = 1;
			goto MailEnd;
		}
		// Send the message.
		//..................
		EmptyTheMessageQue();

		ulResult = MAPISendMail(lHandle,(ULONG)hMainWindow,lpmsg,MAPI_DIALOG,0);

		EmptyTheMessageQue();

		if (ulResult)
		{
			dwComposeNote = 1;
			SetLastError(ulResult + MAPI_BASE);
			ErrorProcedure(lpMapiDllName,IDS_MAPI_SEND_MAIL,MB_OK);
		}

		MailEnd:

		if (hComposeOpen)
		{
			CloseHandle(hComposeOpen);
			hComposeOpen = 0;
		}
		if (hComposeEvent)
		{
			CloseHandle(hComposeEvent);
			hComposeEvent = 0;
		}
		// If we have memory allocated, free it.
		//......................................
		if (lpmsg)
		{
			PvFree(lpmsg->lpszMessageType);
			PvFree(lpmsg->lpszConversationID);
			PvFree((LPBYTE)lpmsg);
		}
		if (lpRecips)
		{
			PvFree((LPBYTE)lpRecips);
		}
		if (lpAttach)
		{
			PvFree((LPBYTE)lpAttach);
		}
		if (lpszSubject)
		{	
			PvFree(lpszSubject);
		}
		if (lpszNoteText)
		{
			PvFree(lpszNoteText);
		}
		lpmsg = NULL;
		lpszSubject = NULL;
		lpszNoteText = NULL;
		cRecips = 0;
		cNewRecips = 0;
		lpRecips = NULL;
		lpAttach = NULL;

		if (dwComposeNote != IDC_MSGENCRYPT)
		{
			break;
		}
	}
	if (hRtf)
	{
		FreeLibrary(hRtf);
	}
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for the Compose, Encrypt, and Send dialog box.
//..................................................................
LRESULT CALLBACK ComposeNoteProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{				
    BOOL					fUnResTo;
    BOOL					fUnResCc;
	BOOL					fUnResBcc;
	BOOL					bResult;
	BOOL					bFatalErr = TRUE;
    LONG					cb;
	LONG					cLines;
    ULONG					ulResult;
    ULONG					idx;
	BOOL					bErr;
	HCURSOR					hOldCur;
	LPBYTE					lpFileName;
	int						iResult;
	int						iAttrib;
	int						iDlgResult;
	UINT					uCheck;
	CHARRANGE				cr;

	cf.cbSize = sizeof(CHARFORMAT2);
	pf.cbSize = sizeof(PARAFORMAT2);

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// The text color button is disabled on entry.
			//............................................
			bNoTextClr = TRUE;
			dwComposeNote = 0;

			// If we did not initialize the spell checker, gray its button.
			//.............................................................
			if (!bUseSentrySpellChecker)
			{
				EnableWindow(GetDlgItem(hDlg,IDC_SPELLCHECK),FALSE);
			}
			// Set the limit on the subject to 256 bytes.
			//...........................................
			SendDlgItemMessage(hDlg,IDC_SUBJECT,EM_SETLIMITTEXT,(WPARAM) 256,0);

			// Setup the rich text edit control.
			//..................................
			SendDlgItemMessage(hDlg,IDC_NOTE,EM_AUTOURLDETECT,(WPARAM)TRUE,0);
			SendDlgItemMessage(hDlg,IDC_NOTE,EM_EXLIMITTEXT,0,FIVEMEGABYTES);

			// Setup event notification.
			//..........................
			SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETEVENTMASK,0,
							  (LPARAM)ENM_KEYEVENTS | ENM_MOUSEEVENTS | ENM_LINK);

			// Setup ole callback.
			//....................
			SetupOleCallback(hDlg,IDC_NOTE);

			// Setup the horizontal scroll for the list box.
			//..............................................
			SendDlgItemMessage(hDlg,IDC_ATTACHMENT,LB_SETHORIZONTALEXTENT,(WPARAM)350,0);

			if (lpmsg)
			{
				// Make sure the old background color is saved in case we
				// respond to a message before composing one.
				//.......................................................
				crSetBkgColor = cfg.savecf.crBackColor;

				// ComposeNote is being called to either forward or reply
				// to a message in the Inbox.  So, we'll initialize the 
				// ComposeNote form with data from the global MapiMessage.
				//........................................................
				lpszSubject = lpmsg->lpszSubject;
				lpszNoteText = lpmsg->lpszNoteText;
				cRecips = lpmsg->nRecipCount;
				cAttach = lpmsg->nFileCount;
				lpRecips = lpmsg->lpRecips;
				lpAttach = lpmsg->lpFiles;
				flSendMsgFlags = lpmsg->flFlags;

				if (cRecips)
				{
					// Set the To recipients.
					//.......................
					bErr = MakeDisplayNameStr(hDlg,szDisplayNames,MAPI_TO,cRecips,lpRecips);
					if (bErr)
					{
						goto cleanup;
					}
					if (*szDisplayNames)
					{
						SetDlgItemText(hDlg,IDC_TO,szDisplayNames);
					}
					// Set the Carbon Copy recipients.
					//................................
					bErr = MakeDisplayNameStr(hDlg,szDisplayNames,MAPI_CC,cRecips,lpRecips);
					if (bErr)
					{
						goto cleanup;
					}
					if (szDisplayNames)
					{
						SetDlgItemText(hDlg,IDC_CC,szDisplayNames);
					}
					// Set the blind copy recipients.
					//...............................
					bErr = MakeDisplayNameStr(hDlg,szDisplayNames,MAPI_BCC,cRecips,lpRecips);
					if (bErr)
					{
						goto cleanup;
					}
					if (szDisplayNames)
					{
						SetDlgItemText(hDlg,IDC_BCC,szDisplayNames);
					}
				}
				SetDlgItemText(hDlg,IDC_SUBJECT,lpmsg->lpszSubject);

				// If we are replying to a message we have to read in
				// the rich text from a file. In this case the
				// address lpmsg->lpszNoteText will be NULL.
				//...................................................
				if (lpmsg->lpszNoteText == NULL && bDeleteReplyFile)
				{
					if (dwMyReplyFormat == 0)
					{
						iAttrib = SF_RTF;
					}
					else
					{
						iAttrib = SF_TEXT;
					}
					bErr = OpenFileStreamIn((LPTSTR)&szMyReplyFile,hDlg,IDC_NOTE,iAttrib);
					
					if (bErr)
					{
						goto cleanup;
					}
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETSEL,(WPARAM)0,(LPARAM)0);
					
					// Let's insert the original message at the beginning.
					//....................................................
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_REPLACESEL,(WPARAM)TRUE,
									  (LPARAM)TEXT("\r\n-----Original Message-----\r\n\r\n"));
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETSEL,(WPARAM)0,(LPARAM)0);

					// Set the current background color for the rich edit control.
					//............................................................
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETBKGNDCOLOR,0,
									  (LPARAM)(COLORREF)crBkgCurrent);
					crOleBkg = crBkgCurrent;
				}
				else
				{
					SetDlgItemText(hDlg,IDC_NOTE,lpmsg->lpszNoteText);

					// Make sure the ole background color is set to the current window
					// color in case we reply to a regular message.
					//................................................................
					crOleBkg = GetSysColor(COLOR_WINDOW);
					crBkgCurrent = crOleBkg;
				}
				// If we have attachments.
				//........................
				if (cAttach)
				{
					for(idx = 0; idx < cAttach; idx++)
					{
						if (lpAttach[idx].lpszFileName)
						{
							lpFileName = PathFindFileName((LPCTSTR)lpAttach[idx].lpszFileName);
							SendDlgItemMessage(hDlg,IDC_ATTACHMENT,LB_ADDSTRING,0,
											  (LPARAM)lpFileName);
						}
					}
				}
				// Tell the controls they have not been modified.
				//...............................................
				SendDlgItemMessage(hDlg,IDC_TO,EM_SETMODIFY,FALSE,0);
				SendDlgItemMessage(hDlg,IDC_CC,EM_SETMODIFY,FALSE,0);
				SendDlgItemMessage(hDlg,IDC_BCC,EM_SETMODIFY,FALSE,0);
				SendDlgItemMessage(hDlg,IDC_SUBJECT,EM_SETMODIFY,FALSE,0);
				SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETMODIFY,FALSE,0);

				// Set the focus on the proper control.
				//.....................................
				if(cRecips)
				{
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				else
				{
					SetFocus(GetDlgItem(hDlg,IDC_TO));
				}
			}
			else
			{
				lpmsg = (lpMapiMessage)PvAlloc(sizeof(MapiMessage));

				if (!lpmsg)
				{
					goto cleanup;
				}
				ZeroMemory(lpmsg,sizeof(MapiMessage));

				lpszSubject = NULL;
				lpszNoteText = NULL;
				cRecips = 0;
				cAttach = 0;
				lpRecips = NULL;
				lpNewRecips = NULL;
				lpAttach = NULL;

				lpmsg->flFlags = flSendMsgFlags;
				SetFocus(GetDlgItem(hDlg,IDC_TO));

				// Lets setup the character formating.
				//....................................
				cf.cbSize = sizeof(CHARFORMAT2);
				if (!cfg.savecf.cbSize)
				{
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_GETCHARFORMAT,0,(LPARAM)&cf);
					CopyMemory(&cfg.savecf,&cf,sizeof(CHARFORMAT2));
					cfg.savecf.crBackColor = crBkgCurrent;
					crOleBkg = crBkgCurrent;
				}
				else
				{
					CopyMemory(&cf,&cfg.savecf,sizeof(CHARFORMAT2));
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETBKGNDCOLOR,0,
								      (LPARAM)(COLORREF)cf.crBackColor);
					crBkgCurrent = cf.crBackColor;
					crSetBkgColor = cf.crBackColor;
					crOleBkg = cf.crBackColor;
					EnableWindow(GetDlgItem(hDlg,IDC_TEXTCLR),TRUE);
					bNoTextClr = FALSE;
				}
				SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_ALL,(LPARAM)&cf);
			}
			// Setup the initial paragraph alignment depending on what is set.
			//................................................................
			pf.cbSize = sizeof(PARAFORMAT2);
			SendMessage(GetDlgItem(hDlg,IDC_NOTE),EM_GETPARAFORMAT,0,(LPARAM)&pf);

			// Set the return request radiobutton as appropriate.
			//...................................................
			if (bReturnReceipt)
			{
				CheckDlgButton(hDlg,IDC_RETURN,BST_CHECKED);
			}
			else
			{
				CheckDlgButton(hDlg,IDC_RETURN,BST_UNCHECKED);
			}
			// Update the radio buttons.
			//..........................
			UpdateRtfRadioButtons(hDlg,IDC_NOTE);

			// Center the dialog box.
			//.......................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return FALSE;
		}

		case WM_NOTIFY:
		{
			LPNMHDR			lpNmhdr;
			LPMSGFILTER		lpMsgFilter;
			LPENLINK		pEnlink;
			LPBYTE			lpLink;
			DWORD			dwLinkSize;
			CHARRANGE		range;

			lpNmhdr = (LPNMHDR)lParam;
			lpMsgFilter = (LPMSGFILTER)lParam;
			pEnlink = (LPENLINK)lParam;

			switch(lpNmhdr->code) 
			{
				case EN_MSGFILTER:
				{
					if (lpNmhdr->idFrom == IDC_NOTE)
					{
						if (lpMsgFilter->msg == WM_LBUTTONUP || lpMsgFilter->msg == WM_KEYUP)
						{
							UpdateRtfRadioButtons(hDlg,lpNmhdr->idFrom);
						}
					}
				}
				break;

				case EN_LINK:
				{
					if (lpNmhdr->code == EN_LINK)
					{
						if (pEnlink->msg == WM_LBUTTONUP)
						{
							// Get the range and allocate the buffer.
							//.......................................
							dwLinkSize = pEnlink->chrg.cpMax - pEnlink->chrg.cpMin;
							if (dwLinkSize)
							{
								lpLink = AllocateMemory(dwLinkSize + 10);
								if (lpLink)
								{
									SetCursor(hCursorArrow);
									range.cpMax = pEnlink->chrg.cpMax;
									range.cpMin = pEnlink->chrg.cpMin;

									SendDlgItemMessage(hDlg,IDC_NOTE,EM_EXSETSEL,0,
													  (LPARAM)(CHARRANGE FAR *)&range);
									SendDlgItemMessage(hDlg,IDC_NOTE,EM_GETSELTEXT,0,
												      (LPARAM)lpLink);
									ShellExecute(NULL,"open",(LPCTSTR)lpLink,NULL,NULL,
												 SW_SHOWNORMAL);
									range.cpMin = -1;
									SendDlgItemMessage(hDlg,IDC_NOTE,EM_EXSETSEL,0,
													  (LPARAM)(CHARRANGE FAR *)&range);
									DeallocateMemory(lpLink);
								}
							}
						}
					}
				}
				break;
			}
		}
		break;

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_FONT:
				{
					SelectCharFormat(hDlg,GetDlgItem(hDlg,IDC_NOTE),(LPBYTE)&cfg.savecf);
				}
				break;

				case IDC_BKG:
				{
					ZeroMemory(&crBkg,sizeof(CHOOSECOLOR));
					lpIconPointer = lpszAppName;
					bChooseBkgColor = TRUE;

					crBkg.lStructSize = sizeof(CHOOSECOLOR);
					crBkg.hwndOwner = hDlg;
					crBkg.rgbResult = crBkgCurrent;
					crBkg.lpCustColors = (LPDWORD)cfg.crBkgCustom;
					crBkg.lpfnHook = MyCCHookProc;
					crBkg.Flags = CC_RGBINIT | CC_SHOWHELP | CC_ENABLEHOOK | CC_FULLOPEN;

					// Go and get the color selection.
					//...............................
					if(!ChooseColor(&crBkg))
					{
						CommDlgBoxErrorProc(IDS_CHOOSE_COLOR);
					}
					else
					{
						// We have a valid color selection.
						//.................................
						crBkgCurrent = crBkg.rgbResult;
						crSetBkgColor = crBkg.rgbResult;
						crOleBkg = crBkg.rgbResult;

						SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETBKGNDCOLOR,0,
										  (LPARAM)(COLORREF)crBkgCurrent);
					}
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_TEXTCLR:
				{
					ZeroMemory(&crText,sizeof(CHOOSECOLOR));
					lpIconPointer = lpszAppName;
					bChooseBkgColor = FALSE;

					crText.lStructSize = sizeof(CHOOSECOLOR);
					crText.hwndOwner = hDlg;
					crText.rgbResult = crTextCurrent;
					crText.lpCustColors = (LPDWORD)cfg.crTextCustom;
					crText.lpfnHook = MyCCHookProc;
					crText.Flags = CC_RGBINIT | CC_SHOWHELP | CC_ENABLEHOOK | CC_FULLOPEN;

					// Go and get the color selection.
					//...............................
					if(!ChooseColor(&crText))
					{
						CommDlgBoxErrorProc(IDS_CHOOSE_COLOR);
					}
					else
					{
						// We have a valid color selection.
						//.................................
						crTextCurrent = crText.rgbResult;

						// Get the current font information from the rich edit control.
						//.............................................................
						SendDlgItemMessage(hDlg,IDC_NOTE,EM_GETCHARFORMAT,(WPARAM)TRUE,
								          (LPARAM)&cf);
						cf.crTextColor = crTextCurrent;
						SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_SELECTION,
										  (LPARAM)&cf);

						SendDlgItemMessage(hDlg,IDC_NOTE,EM_EXGETSEL,0,(LPARAM)&cr);

						// Only save the new text color if it pertains to the
						// whole control and not just a selection.
						//...................................................
						if (cr.cpMax == cr.cpMin)
						{
							// Save the text color selection.
							//...............................
							CopyMemory(&cfg.savecf,&cf,sizeof(CHARFORMAT2));
						}
					}
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_BOLD:
				{
					// Toggle the bold effect.
					//........................
					cf.dwMask = CFM_BOLD;
					SendMessage(GetDlgItem(hDlg,IDC_NOTE),EM_GETCHARFORMAT,TRUE,(LPARAM)&cf);
					cf.dwEffects ^= CFE_BOLD;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_SELECTION,
									  (LPARAM)&cf);

					// Now we have to toggle the bold radiobutton.
					//............................................
					uCheck = IsDlgButtonChecked(hDlg,IDC_BOLD);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
					}
					else
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_BOLD,uCheck);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_ITALIC:
				{
					// Toggle the bold effect.
					//........................
					cf.dwMask = CFM_ITALIC;
					SendMessage(GetDlgItem(hDlg,IDC_NOTE),EM_GETCHARFORMAT,TRUE,(LPARAM)&cf);
					cf.dwEffects ^= CFE_ITALIC;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_SELECTION,
									  (LPARAM)&cf);

					// Now we have to toggle the bold radiobutton.
					//............................................
					uCheck = IsDlgButtonChecked(hDlg,IDC_ITALIC);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
					}
					else
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_ITALIC,uCheck);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_UNDERLINE:
				{
					// Toggle the bold effect.
					//........................
					cf.dwMask = CFM_UNDERLINE | CFM_UNDERLINETYPE;
					SendMessage(GetDlgItem(hDlg,IDC_NOTE),EM_GETCHARFORMAT,TRUE,(LPARAM)&cf);
					cf.dwEffects ^= CFE_UNDERLINE;

					// If we have rich edit 3.0 or greater we can select the
					// type of underline we have if we are setting it.
					//......................................................
					if (bHaveRichEdit3 && (cf.dwEffects & CFE_UNDERLINE))
					{
						EnableWindow(hDlg,FALSE);

						iDlgResult = DialogBox(hInst,TEXT("SELECTUNDERLINE"),hDlg,
											  (DLGPROC)SelectUnderlineProc);
						EnableWindow(hDlg,TRUE);

						// See if we had a system error in creating the dialog box.
						//.........................................................
						if (iDlgResult == -1)
						{
							ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);	
							SetFocus(GetDlgItem(hDlg,IDC_NOTE));
							break;
						}
						// Quit if we canceled.
						//.....................
						if (iDlgResult == IDCANCEL)
						{
							SetFocus(GetDlgItem(hDlg,IDC_NOTE));
							break;
						}

					}
					// Set our settings for underlining.
					//..................................
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_SELECTION,
									  (LPARAM)&cf);

					// Now we have to toggle the bold radiobutton.
					//............................................
					uCheck = IsDlgButtonChecked(hDlg,IDC_UNDERLINE);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
					}
					else
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_UNDERLINE,uCheck);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_LEFT:
				{
					pf.dwMask = PFM_ALIGNMENT;
					pf.wAlignment = PFA_LEFT;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETPARAFORMAT,0,(LPARAM)&pf);
					CheckRadioButton(hDlg,IDC_LEFT,IDC_RIGHT,IDC_LEFT);
					cf.dwMask = CFM_SIZE | CFM_BOLD | CFM_ITALIC | CFM_STRIKEOUT | CFM_UNDERLINE | CFM_COLOR | CFM_FACE | CFM_CHARSET;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_GETCHARFORMAT,(WPARAM)TRUE,(LPARAM)&cf);
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cf);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_CENTER:
				{
					pf.dwMask = PFM_ALIGNMENT;
					pf.wAlignment = PFA_CENTER;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETPARAFORMAT,0,(LPARAM)&pf);
					CheckRadioButton(hDlg,IDC_LEFT,IDC_RIGHT,IDC_CENTER);
					cf.dwMask = CFM_SIZE | CFM_BOLD | CFM_ITALIC | CFM_STRIKEOUT | CFM_UNDERLINE | CFM_COLOR | CFM_FACE | CFM_CHARSET;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_GETCHARFORMAT,(WPARAM)TRUE,(LPARAM)&cf);
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cf);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_RIGHT:
				{
					pf.dwMask = PFM_ALIGNMENT;
					pf.wAlignment = PFA_RIGHT;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETPARAFORMAT,0,(LPARAM)&pf);
					CheckRadioButton(hDlg,IDC_LEFT,IDC_RIGHT,IDC_RIGHT);
					cf.dwMask = CFM_SIZE | CFM_BOLD | CFM_ITALIC | CFM_STRIKEOUT | CFM_UNDERLINE | CFM_COLOR | CFM_FACE | CFM_CHARSET;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_GETCHARFORMAT,(WPARAM)TRUE,(LPARAM)&cf);
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cf);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_BULLETS:
				{
					pf.dwMask = PFM_NUMBERING;
					if (IsDlgButtonChecked(hDlg,IDC_BULLETS))
					{
						pf.wNumbering = 0;
						uCheck = BST_UNCHECKED;
					}
					else
					{	
						// If we have Richedit 3.0 or above we can select bullets
						// and styles.
						//.......................................................
						if (bHaveRichEdit3)
						{
							pf.cbSize = sizeof(PARAFORMAT2);
							SendMessage(GetDlgItem(hDlg,IDC_NOTE),EM_GETPARAFORMAT,0,
												  (LPARAM)&pf);

							EnableWindow(hDlg,FALSE);

							iDlgResult = DialogBox(hInst,TEXT("BULLETS"),hDlg,
												   (DLGPROC)BulletsProc);
							EnableWindow(hDlg,TRUE);

							// See if we had a system error in creating the dialog box.
							//.........................................................
							if (iDlgResult == -1)
							{
								ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
								SetFocus(GetDlgItem(hDlg,IDC_NOTE));
								break;
							}
							// Quit if we canceled.
							//.....................
							if (iDlgResult == IDCANCEL)
							{
								SetFocus(GetDlgItem(hDlg,IDC_NOTE));
								break;
							}
							pf.wNumberingStart = 1;
							if (pf.wNumbering > PFN_BULLET)
							{
								pf.dwMask = (PFM_NUMBERING | PFM_NUMBERINGSTART | PFM_NUMBERINGSTYLE | 
										     PFM_NUMBERINGTAB | PFM_OFFSET | PFM_STARTINDENT);
							}
							else
							{
								pf.dwMask = PFM_NUMBERING;
							}
						}
						else
						{
							pf.wNumbering = PFN_BULLET;
						}
						uCheck = BST_CHECKED;
					}
					cf.dwMask = CFM_SIZE | CFM_BOLD | CFM_ITALIC | CFM_STRIKEOUT | CFM_UNDERLINE | CFM_COLOR | CFM_FACE | CFM_CHARSET;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_GETCHARFORMAT,(WPARAM)TRUE,(LPARAM)&cf);
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cf);
					pf.cbSize = sizeof(PARAFORMAT2);
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETPARAFORMAT,0,(LPARAM)&pf);
					CheckDlgButton(hDlg,IDC_BULLETS,uCheck);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_RETURN:
				{
					if (IsDlgButtonChecked(hDlg,IDC_RETURN))
					{
						bReturnReceipt = FALSE;
						uCheck = BST_UNCHECKED;
					}
					else
					{
						bReturnReceipt = TRUE;
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_RETURN,uCheck);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_ADDRBOOK:
				{
					// Resolve any names in the recipients boxes first.
					//.................................................
					SendMessage(hDlg,WM_COMMAND,MAKELONG(IDC_RESOLVE,0),0);

					// Diable the dialog box.
					//.......................
					EnableWindow(hDlg,FALSE);

					// Display the address book and get the recipients.
					//.................................................
					bAddressBookDisplayed = TRUE;
					ulResult = MAPIAddress(lHandle,(ULONG)hDlg,NULL,
										   3,NULL,cRecips,lpRecips,0,0,
										   &cNewRecips,&lpNewRecips);

					bAddressBookDisplayed = FALSE;

					if (ulResult)
					{
						if (ulResult != MAPI_E_USER_ABORT)
						{
							SetLastError(ulResult + MAPI_BASE);
							ErrorProcedure(lpMapiDllName,IDS_MAPI_ADDRESS,MB_OK);
						}
					}
					else
					{
						if (cNewRecips)
						{
							bErr = PvFree((LPBYTE)lpRecips);
							if (bErr)
							{
								goto cleanup;
							}
							lpRecips = (lpMapiRecipDesc)PvAlloc(cNewRecips*sizeof(MapiRecipDesc));
							if (!lpRecips)
							{
								goto cleanup;
							}
							cRecips = cNewRecips;

							while(cNewRecips--)
							{
								CopyRecipient(lpRecips,&lpRecips[cNewRecips],
											  &lpNewRecips[cNewRecips]);
							}

							ulResult = MAPIFreeBuffer(lpNewRecips);
							if (ulResult != SUCCESS_SUCCESS)
							{
								SetLastError(ulResult + MAPI_BASE);
								ErrorProcedure(lpMapiDllName,IDS_MAPI_FREEBUFFER,MB_OK);
								goto cleanup;
							}
							lpNewRecips = NULL;
							cNewRecips = 0;

							bErr = MakeDisplayNameStr(hDlg,szDisplayNames,MAPI_TO,
								                      cRecips,lpRecips);
							if (bErr)
							{
								goto cleanup;
							}
							if (*szDisplayNames)
							{
								SetDlgItemText(hDlg,IDC_TO,szDisplayNames);
							}

							bErr = MakeDisplayNameStr(hDlg,szDisplayNames,MAPI_CC,
								                      cRecips,lpRecips);
							if (bErr)
							{
								goto cleanup;
							}
							if (*szDisplayNames)
							{
								SetDlgItemText(hDlg,IDC_CC,szDisplayNames);
							}
							
							bErr = MakeDisplayNameStr(hDlg,szDisplayNames,MAPI_BCC,
								                      cRecips,lpRecips);
							if (bErr)
							{
								goto cleanup;
							}
							if (*szDisplayNames)
							{
								SetDlgItemText(hDlg,IDC_BCC,szDisplayNames);
							}
							SendDlgItemMessage(hDlg,IDC_TO,EM_SETMODIFY,FALSE,0);
							SendDlgItemMessage(hDlg,IDC_CC,EM_SETMODIFY,FALSE,0);
							SendDlgItemMessage(hDlg,IDC_BCC,EM_SETMODIFY,FALSE,0);
						}
					}
					EnableWindow(hDlg,TRUE);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_ATTACH:
				{
					ULONG		ulMyAttach;
					ULONG		idx;

					// Display our tip.
					//.................
					if (cfg.dwTips & ATTACH_TIP)
					{
						dwTip = ATTACH_TIP;
						dwTipString = IDS_ATTACH_TIP;

						iResult = DialogBox(hInst,TEXT("TSCGTIP"),hMainWindow,
										   (DLGPROC)TscgTipProc);

						EmptyTheMessageQue();

						// See if we had a system error in creating the dialog box.
						//.........................................................
						if (iResult == -1)
						{
							ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
							break;
						}
					}
					// Disable the dialog box.
					//........................
					ShowWindow(hDlg,SW_HIDE);
					EnableWindow(hDlg,FALSE);

					ulMyAttach = cAttach;

					if (GetNextFile(hDlg,(ULONG)-1,&cAttach,&lpAttach) == SUCCESS_SUCCESS)
					{
						// We added some files so display their names.
						//............................................
						for (idx = ulMyAttach; idx < cAttach; idx++)
						{
							if (lpAttach[idx].lpszFileName)
							{
								SendDlgItemMessage(hDlg,IDC_ATTACHMENT,LB_ADDSTRING,0,
											      (LPARAM)lpAttach[idx].lpszFileName);
							}
						}
					}
					EnableWindow(hDlg,TRUE);
					ShowWindow(hDlg,SW_SHOW);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;

				case IDC_SPELLCHECK:
				{
//					SHORT		sError;
//					DWORD		dwStart;
//					DWORD		dwEnd;

					dwSpellHelp = ChangeHelpTopic(IDH_SPELL_CHECKER);

					// Determine if we only have a selection to test.
					//...............................................
//					SendDlgItemMessage(hDlg,IDC_NOTE,EM_EXGETSEL,0,(LPARAM)&cr);

//					if (cr.cpMax == cr.cpMin)
//					{
//						sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,GetDlgItem(hDlg,IDC_NOTE),
//														FALSE,hInst,&szCheckSpellingDlg,
//														&szEditLexDlg,&szOptionsDlg,
//														&szNewLexDlg);
//					}
//					else
//					{
//						sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,GetDlgItem(hDlg,IDC_NOTE),
//														TRUE,hInst,&szCheckSpellingDlg,
//														&szEditLexDlg,&szOptionsDlg,
//														&szNewLexDlg);
//					}
//					SentrySpellError(sError);
//					SetUserLexiconFiles();
//					EmptyTheMessageQue();

					// Now check the spelling in the subject edit control.
					//....................................................
//					SendDlgItemMessage(hDlg,IDC_SUBJECT,EM_GETSEL,(WPARAM)&dwStart,
//								      (LPARAM)&dwEnd);

//					if (dwEnd > 0)
//					{
//						if (dwStart == dwEnd)
//						{
//							sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,
//															GetDlgItem(hDlg,IDC_SUBJECT),
//															FALSE,hInst,&szCheckSpellingDlg,
//															&szEditLexDlg,&szOptionsDlg,
//															&szNewLexDlg);
//						}
//						else
//						{
//							sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,
//															GetDlgItem(hDlg,IDC_SUBJECT),
//															TRUE,hInst,&szCheckSpellingDlg,
//															&szEditLexDlg,&szOptionsDlg,
//															&szNewLexDlg);
//						}
//						SentrySpellError(sError);
//						SetUserLexiconFiles();
//					}
//					EmptyTheMessageQue();

					SetFocus(GetDlgItem(hDlg,IDC_NOTE));

					ChangeHelpTopic(dwSpellHelp);
				}
				break;

				case IDC_RESOLVE:
				case IDC_MSGENCRYPT:
				{
					fUnResTo = FALSE;
					fUnResCc = FALSE;
					fUnResBcc = FALSE;

					hOldCur = SetCursor(hCursorWait); 

					// Get the names from the To: field and resolve them first.
					//.........................................................
					if (cb = SendDlgItemMessage(hDlg,IDC_TO,WM_GETTEXT,
											   (WPARAM)sizeof(szUnResNames), 
											   (LPARAM)&szUnResNames))
					{
						if (!ResolveFriendlyNames(hDlg,(LPSTR)&szUnResNames,MAPI_TO,
												  &cRecips,&lpRecips))
						{
							bErr = MakeDisplayNameStr(hDlg,(LPTSTR)&szDisplayNames,MAPI_TO,
								                      cRecips,lpRecips);
							if (bErr)
							{
								goto cleanup;
							}
							if (*szDisplayNames)
							{
								if (*szUnResNames)
								{
									StringCbCatEx((LPTSTR)&szDisplayNames,TO_EDIT_MAX,"; ",
												   NULL,NULL,dwStringSafeFlag);
									StringCbCatEx((LPTSTR)&szDisplayNames,TO_EDIT_MAX,
												  (LPCTSTR)&szUnResNames,NULL,NULL,
												   dwStringSafeFlag);
									fUnResTo = TRUE;
								}
								SetDlgItemText(hDlg,IDC_TO,(LPCTSTR)&szDisplayNames);
							}			
							else
							{
								if (*szUnResNames)
								{
									SetDlgItemText(hDlg,IDC_TO,(LPCTSTR)&szUnResNames);
									fUnResTo = TRUE;
								}
							}
						}
						else
						{
							goto cleanup;
						}
					}
					// Now, get the names from the Cc: field and resolve them.
					//........................................................
					if (cb = SendDlgItemMessage(hDlg,IDC_CC,WM_GETTEXT,
											   (WPARAM)sizeof(szUnResNames), 
											   (LPARAM)&szUnResNames))
					{
						if (!ResolveFriendlyNames(hDlg,(LPSTR)&szUnResNames,MAPI_CC,&cRecips, 
												  &lpRecips))
						{
							bErr = MakeDisplayNameStr(hDlg,(LPTSTR)&szDisplayNames,MAPI_CC,
													  cRecips,lpRecips);
							if (bErr)
							{
								goto cleanup;
							}
							if (*szDisplayNames)
							{
								if (*szUnResNames)
								{
									StringCbCatEx((LPTSTR)&szDisplayNames,TO_EDIT_MAX,"; ",
												   NULL,NULL,dwStringSafeFlag);
									StringCbCatEx((LPTSTR)&szDisplayNames,TO_EDIT_MAX,
												  (LPCTSTR)&szUnResNames,NULL,NULL,
												   dwStringSafeFlag);
									fUnResCc = TRUE;
								}
								SetDlgItemText(hDlg,IDC_CC,(LPCTSTR)&szDisplayNames);
							}
							else
							{
								if (*szUnResNames)
								{
									SetDlgItemText(hDlg,IDC_CC,(LPCTSTR)&szUnResNames);
									fUnResCc = TRUE;
								}
							}
						}
						else
						{
							goto cleanup;
						}
					}
					// Now, get the names from the Bcc: field and resolve them.
					//........................................................
					if (cb = SendDlgItemMessage(hDlg,IDC_BCC,WM_GETTEXT,
											   (WPARAM)sizeof(szUnResNames), 
											   (LPARAM)&szUnResNames))
					{
						if (!ResolveFriendlyNames(hDlg,(LPSTR)&szUnResNames,MAPI_BCC,&cRecips, 
												  &lpRecips))
						{
							bErr = MakeDisplayNameStr(hDlg,(LPTSTR)&szDisplayNames,MAPI_BCC,
								                      cRecips,lpRecips);
							if (bErr)
							{
								goto cleanup;
							}
							if (*szDisplayNames)
							{
								if (*szUnResNames)
								{
									StringCbCatEx((LPTSTR)&szDisplayNames,TO_EDIT_MAX,"; ",
												   NULL,NULL,dwStringSafeFlag);
									StringCbCatEx((LPTSTR)&szDisplayNames,TO_EDIT_MAX,
												  (LPCTSTR)&szUnResNames,NULL,NULL,
												   dwStringSafeFlag);
									fUnResCc = TRUE;
								}
								SetDlgItemText(hDlg,IDC_BCC,(LPCTSTR)&szDisplayNames);
							}
							else
							{
								if (*szUnResNames)
								{
									SetDlgItemText(hDlg,IDC_CC,(LPCTSTR)&szUnResNames);
									fUnResCc = TRUE;
								}
							}
						}
						else
						{
							goto cleanup;
						}
					}
					// If we were just Resolving Names then we can leave now.
					//.......................................................
					if (LOWORD(wParam) == IDC_RESOLVE)
					{
						SetCursor(hOldCur);
						SetFocus(GetDlgItem(hDlg,IDC_NOTE));
						break;
					}
					if (cRecips == 0 || fUnResTo || fUnResCc || fUnResBcc)
					{
						if (!cRecips)
						{
							MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_MAPI_NORECIPS,
										   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
						}
						if (fUnResTo)
						{
							SetFocus(GetDlgItem(hDlg,IDC_TO));
						}
						else if (fUnResCc)
						{
							SetFocus(GetDlgItem(hDlg,IDC_CC));
						}
						else if (fUnResBcc)
						{
							SetFocus(GetDlgItem(hDlg,IDC_BCC));
						}
						else
						{
							SetFocus(GetDlgItem(hDlg,IDC_TO));
						}
						SetCursor(hOldCur);
						break;
					}
					// Everything is OK so far, lets get the Subject
					// and the NoteText and try to send the message.
					//..............................................
					if (cb = SendDlgItemMessage(hDlg,IDC_SUBJECT,EM_LINELENGTH,0,0L))
					{
						bErr = PvFree(lpszSubject);
						if (bErr)
						{
							goto cleanup;
						}
						lpszSubject = (LPTSTR)PvAlloc(cb + 1);

						if (!lpszSubject)
						{
							goto cleanup;
						}
						GetDlgItemText(hDlg,IDC_SUBJECT,lpszSubject,(int)cb+1);
					}
					else
					{
						// Ask if we want to enter a subject or not.
						//..........................................
						iResult = MessageBoxProc(hDlg,IDS_QUESTION,IDS_MAPI_NOSUBJECT,
												 MB_ICONQUESTION | MB_YESNO,
												 MB_ICONQUESTION,0);
						if (iResult == IDYES)
						{
							SetFocus(GetDlgItem(hDlg,IDC_SUBJECT));
							break;
						}
						else
						{
							// Setup a dummy subject of length 1.
							//...................................
							bErr = PvFree(lpszSubject);
							if (bErr)
							{
								goto cleanup;
							}
							lpszSubject = (LPTSTR)PvAlloc(1);

							if (!lpszSubject)
							{
								goto cleanup;
							}
							*lpszSubject = '\0';
						}
					}
					// Disable the dialog box. We are encrypting or sending.
					//......................................................
					EnableWindow(hDlg,FALSE);

					// We are encrypting get the rich text content into a file.
					//............................................................
					bTempRtf = FALSE;

					cb = 0;
					cLines = SendDlgItemMessage(hDlg,IDC_NOTE,EM_GETLINECOUNT,0,0L);

					if (cLines)
					{
						// Get the total number of bytes in the multi-line.
						//.................................................
						cb = SendDlgItemMessage(hDlg,IDC_NOTE,EM_LINEINDEX,
											   (UINT)cLines - 1,0L);
						cb += SendDlgItemMessage(hDlg,IDC_NOTE,EM_LINELENGTH,(UINT)cb,0L);
					}
					if (cb)
					{
						// Get the rich text data into a temporary file.
						//..............................................
						bResult = CreateFileStreamOut((LPTSTR)&szFileToEncipher,hDlg,IDC_NOTE,SF_RTF,TRUE);
						if (!bResult)
						{
							goto cleanup;
						}
						bTempRtf = TRUE;
					}
					else
					{
						MessageBoxProc(hDlg,IDS_ADVISORY,IDS_MAPI_NOTEXT,
									   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
						EnableWindow(hDlg,TRUE);
						SetFocus(GetDlgItem(hDlg,IDC_NOTE));
						break;
					}
					// Setup the contents of the message in the msg structure.
					//........................................................
					lpmsg->lpszSubject = lpszSubject;

					// Set the notetext to null.
					//..........................
					lpmsg->lpszNoteText = NULL;
					
					lpmsg->nRecipCount = cRecips;
					lpmsg->lpRecips = lpRecips;
					lpmsg->nFileCount = cAttach;
					lpmsg->lpFiles = lpAttach;
					lpmsg->flFlags = flSendMsgFlags;

					bFatalErr = FALSE;

					cleanup:

					EnableWindow(hDlg,TRUE);

					if (hOldCur)
					{
						SetCursor(hOldCur);
					}
				}
				
				case IDCANCEL:
				{
					// Make sure we save any background color we set.
					//...............................................
					cfg.savecf.crBackColor = crSetBkgColor;

					// Set all of the controls in the dialog box to empty strings.
					//............................................................
					SetDlgItemText(hDlg,IDC_TO,(LPCTSTR)lpszNullString);
					SetDlgItemText(hDlg,IDC_CC,(LPCTSTR)lpszNullString);
					SetDlgItemText(hDlg,IDC_BCC,(LPCTSTR)lpszNullString);
					SetDlgItemText(hDlg,IDC_SUBJECT,(LPCTSTR)lpszNullString);
					SendDlgItemMessage(hDlg,IDC_ATTACHMENT,LB_RESETCONTENT,0,0);
					SendDlgItemMessage(hDlg,IDC_NOTE,WM_SETTEXT,0,(LPARAM)lpszNullString);

					// Only deallocate the memory if we have sent the message
					// or cancelled or have a fatal error.
					//.......................................................
					if (LOWORD(wParam) == IDCANCEL || bFatalErr)
					{
						PvFree(lpmsg->lpszMessageType);
						PvFree(lpmsg->lpszConversationID);
						PvFree((LPBYTE)lpmsg);
						PvFree((LPBYTE)lpRecips);
						PvFree((LPBYTE)lpAttach);
						PvFree(lpszSubject);
						PvFree(lpszNoteText);

						lpmsg = NULL;
						lpRecips = NULL;
						lpAttach = NULL;
						lpszSubject = NULL;
						lpszNoteText = NULL;

						if (!bFatalErr)
						{
							dwComposeNote = LOWORD(wParam);
						}
						else
						{
							dwComposeNote = 1;
						}
						DestroyWindow(hDlg);
					}
					else if (LOWORD(wParam) == IDC_MSGENCRYPT)
					{
						dwComposeNote = IDC_MSGENCRYPT;
						DestroyWindow(hDlg);
					}
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			if (!bAddressBookDisplayed)
			{
				PopupHelp(hDlg,lParam);
			}
		}
		break;

		case WM_CONTEXTMENU:
		{
			HWND		hControl;
			HWND		hControl1;
			
			hControl = GetDlgItem(hDlg,IDC_NOTE);
			hControl1 = GetDlgItem(hDlg,IDC_ATTACHMENT);
			if (hControl == (HWND)wParam)
			{
				RtfContextMenu(hDlg,(HWND)wParam,lParam,IDC_NOTE);
			}
			else if (hControl1 == (HWND)wParam)
			{
				AttachContextMenu(hDlg,(HWND)wParam,lParam);
			}
			else
			{
				WhatsThis(hDlg,(HWND)wParam,lParam);
			}
		}
		break;

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_DESTROY:
		{
			// Notify the compose note procedure that it can
			// continue.
			//..............................................
			SetEvent(hComposeEvent);
		}
		break;

		default:
		{
			if (uiMsg == uComDlgHelpMsg && uComDlgHelpMsg)
			{
				DisplayMyHelp(hDlg);
			}
			else if (uiMsg == uFindMsgString && uFindMsgString)
			{
				lpFr = (LPFINDREPLACE)lParam;
				MyFindDlgBox();
			}
			else
			{
				return(FALSE);
			}
			break;
		}
	}
	return(TRUE);
}

// Select the style of underline we will use.
//...........................................
LRESULT CALLBACK SelectUnderlineProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	int		iStyle = IDC_ULALL;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the default underline style.
			//...................................
			if (cf.bUnderlineType == CFU_UNDERLINE)
			{
				iStyle = IDC_ULALL;
			}
			else if (cf.bUnderlineType == CFU_UNDERLINEDOTTED)
			{
				iStyle = IDC_ULDOTTED;
			}
			else if (cf.bUnderlineType == CFU_UNDERLINEDASH)
			{
				iStyle = IDC_ULDASH;
			}
			else if (cf.bUnderlineType == CFU_UNDERLINEDASHDOT)
			{
				iStyle = IDC_ULDASHDOT;
			}
			else if (cf.bUnderlineType == CFU_UNDERLINEDASHDOTDOT)
			{
				iStyle = IDC_ULDASHDOTDOT;
			}
			else if (cf.bUnderlineType == CFU_UNDERLINEWAVE)
			{
				iStyle = IDC_ULWAVE;
			}
			CheckRadioButton(hDlg,IDC_ULALL,IDC_ULWAVE,iStyle);

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_ULALL:
				{
					cf.bUnderlineType = CFU_UNDERLINE;
					CheckRadioButton(hDlg,IDC_ULALL,IDC_ULWAVE,IDC_ULALL);
				}
				break;

				case IDC_ULDOTTED:
				{
					cf.bUnderlineType = CFU_UNDERLINEDOTTED;
					CheckRadioButton(hDlg,IDC_ULALL,IDC_ULWAVE,IDC_ULDOTTED);
				}
				break;

				case IDC_ULDASH:
				{
					cf.bUnderlineType = CFU_UNDERLINEDASH;
					CheckRadioButton(hDlg,IDC_ULALL,IDC_ULWAVE,IDC_ULDASH);
				}
				break;

				case IDC_ULDASHDOT:
				{
					cf.bUnderlineType = CFU_UNDERLINEDASHDOT;
					CheckRadioButton(hDlg,IDC_ULALL,IDC_ULWAVE,IDC_ULDASHDOT);
				}
				break;

				case IDC_ULDASHDOTDOT:
				{
					cf.bUnderlineType = CFU_UNDERLINEDASHDOTDOT;
					CheckRadioButton(hDlg,IDC_ULALL,IDC_ULWAVE,IDC_ULDASHDOTDOT);
				}
				break;

				case IDC_ULWAVE:
				{
					cf.bUnderlineType = CFU_UNDERLINEWAVE;
					CheckRadioButton(hDlg,IDC_ULALL,IDC_ULWAVE,IDC_ULWAVE);
				}
				break;

				case IDOK:
				{
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Select the style of bullet to use.
//...................................
LRESULT CALLBACK BulletsProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	int			iMyBullet;
	int			iMyStyle;
	BOOL		bReturn;
	LONG		lOffset;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the default bullet.
			//..........................
			CheckRadioButton(hDlg,IDC_B1,IDC_B6,IDC_B2);
			CheckRadioButton(hDlg,IDC_B7,IDC_B10,IDC_B9);
			iBullet = IDC_B2;
			iStyle = IDC_B9;

			pf.wNumbering = 2;
			pf.wNumberingStyle = 0x200;

			// We have to normalize the offset value.
			//.......................................
			lOffset = pf.dxOffset + pf.dxStartIndent;
			SetDlgItemInt(hDlg,IDC_SEQ_INDENT,lOffset,FALSE);

			// Display the current spacing between paragraph number and text.
			//...............................................................
			SetDlgItemInt(hDlg,IDC_SPACE_B,pf.wNumberingTab,FALSE);
			SetDlgItemInt(hDlg,IDC_START_INDENT,pf.dxStartIndent,FALSE);

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_B1:
				case IDC_B2:
				case IDC_B3:
				case IDC_B4:
				case IDC_B5:
				case IDC_B6:
				{
					iMyBullet = LOWORD(wParam);
	
					// No change in the selection.
					//............................
					if (iMyBullet == iBullet)
					{
						break;
					}
					CheckRadioButton(hDlg,IDC_B1,IDC_B6,iMyBullet);
					pf.wNumbering = ((iMyBullet - IDC_B1) + 1);

					// Turn off the style options.
					//............................
					if (iMyBullet == IDC_B1)
					{
						CheckDlgButton(hDlg,iStyle,BST_UNCHECKED);
						EnableWindow(GetDlgItem(hDlg,IDC_B7),FALSE);
						EnableWindow(GetDlgItem(hDlg,IDC_B8),FALSE);
						EnableWindow(GetDlgItem(hDlg,IDC_B9),FALSE);
						EnableWindow(GetDlgItem(hDlg,IDC_B10),FALSE);
					}
					else if (iBullet == IDC_B1)
					{
						EnableWindow(GetDlgItem(hDlg,IDC_B7),TRUE);
						EnableWindow(GetDlgItem(hDlg,IDC_B8),TRUE);
						EnableWindow(GetDlgItem(hDlg,IDC_B9),TRUE);
						EnableWindow(GetDlgItem(hDlg,IDC_B10),TRUE);
						CheckDlgButton(hDlg,iStyle,BST_CHECKED);
					}
					iBullet = iMyBullet;
				}
				break;

				case IDC_B7:
				case IDC_B8:
				case IDC_B9:
				case IDC_B10:
				{
					if (iBullet != IDC_B1)
					{
						iMyStyle = LOWORD(wParam);

						if (iMyStyle != iStyle)
						{
							iStyle = iMyStyle;

							if (iStyle == IDC_B7)
							{
								pf.wNumberingStyle = 0;
							}
							else if (iStyle == IDC_B8)
							{
								pf.wNumberingStyle = 0x100;
							}
							else if (iStyle == IDC_B9)
							{
								pf.wNumberingStyle = 0x200;
							}
							else
							{
								pf.wNumberingStyle = 0x300;
							}
							CheckRadioButton(hDlg,IDC_B7,IDC_B10,iStyle);
						}
					}
				}
				break;

				case IDOK:
				{
					// Get the space between paragraph numbers and text.
					//..................................................
					pf.wNumberingTab = GetDlgItemInt(hDlg,IDC_SPACE_B,&bReturn,FALSE);

					// Get the indentation settings.
					//..............................
					pf.dxStartIndent = GetDlgItemInt(hDlg,IDC_START_INDENT,&bReturn,FALSE);
					pf.dxOffset = GetDlgItemInt(hDlg,IDC_SEQ_INDENT,&bReturn,FALSE);

					// Special case for start indent equal to 0 with an offset value.
					//...............................................................
					if (pf.dxStartIndent == 0 && pf.dxOffset > 0)
					{
						pf.dxStartIndent = pf.dxOffset;
						pf.dxOffset = 0;
					}
					else
					{
						// Make the offset value relative to the start indent value.
						// It can be a negative value.
						//..........................................................
						pf.dxOffset -= pf.dxStartIndent;
					}
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Send file as an e-mail attachment.
//...................................
VOID SendFileAsAttachment()
{
	OPENFILENAME	ofn;
	DWORD			dwOldHelpTopic;
	ULONG			ulResult;
	BOOL			bResult;
	HCURSOR			hCurrentCursor = 0;

	// We have a process in progress.
	//...............................
	bProcessInProgress = TRUE;

	// Change the help topic.
	//.......................
	dwOldHelpTopic = ChangeHelpTopic(IDH_SENDASATTACHMENT);

	// If we are not logged onto MAPI, do so.
	//.......................................
	if (!bLoggedOn)
	{
		bResult = LogonToMapi(IDH_SENDASATTACHMENT,FALSE,FALSE);
		if (!bResult)
		{
			goto EmailEnd;
		}
	}
	EmptyTheMessageQue();

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	// Initialize with specific information for this procedure.
	//.........................................................
	ofn.lpstrFile = szDestination;
	ofn.nMaxFile = sizeof(szDestination);
	ofn.hwndOwner = hMainWindow;
	ofn.lpstrFilter = TEXT("All Files [*.*]\0*.*\0Tscg Files [.rng;.rsakey;.tsc;.otp;.pad;.tsig;.jrl]\0*.rng;*.rsakey;*.tsc;*.otp;*.pad;*.tsig;*.jrl\0Compressed Files [.pkd;.lha;.zip;.arj]\0*.pkd;*.lha;*.zip;*.arj\0Adobe PDF Files [.pdf]\0*.pdf\0Executable Files [.exe;.dll;.ocx]\0*.exe;*.dll;*.ocx\0Image Files [.bmp;.dib;.gif;.jpg;,ico;,cur]\0*.bmp;*.dib;*.gif;*.jpg;*.ico;*.cur\0Word Documents [.doc]\0*.doc\0Web Pages [.htm;.html]\0*.htm;*.html\0Rich Text Format [.rtf]\0*.rtf\0Text Files [.txt]\0*.txt\0Lotus 1-2-3 [.wk1;.wk3]\0*.wk1;*.wk3\0Microsoft Excel Worksheet [.xls;.xlw]\0*.xls;*.xlw\0Windows Write [.wri]\0*.wri\0WordPerfect 5.x [.doc]\0*.doc\0WordPerfect 6.x [.wpd;.doc]\0*.wpd;*.doc\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Select File to Send as Document");
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
		         OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | 
				 OFN_HIDEREADONLY);
	ofn.lpstrDefExt = NULL;
	ofn.lpfnHook = MyOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	// Get the key file to add to a key ring and check it out.
	//........................................................
	ZeroMemory(&szDestination,sizeof(szDestination));

	if (!GetOpenFileName(&ofn))
	{
		CommDlgBoxErrorProc(IDS_GET_FILES);
		goto EmailEnd;
	}
	SaveDirName((LPBYTE)&szDestination,SAVE_SOURCE,TRUE);

	// Get a pointer to the file name.
	//................................
	lpFileName = PathFindFileName((LPCTSTR)szDestination);

	EmptyTheMessageQue();

	hCurrentCursor = SetCursor(hCursorWait);

	ulResult = MAPISendDocuments((ULONG)hMainWindow,lpszDelimChar,(LPTSTR)&szDestination,
								(LPTSTR)lpFileName,0L);

	EmptyTheMessageQue();

	if(hCurrentCursor)
	{
		SetCursor(hCurrentCursor);
	}
	if (ulResult != SUCCESS_SUCCESS)
	{
		SetLastError(ulResult + MAPI_BASE);
		ErrorProcedure(lpMapiDllName,IDS_MAPI_SEND_DOCS,MB_OK);
	}
					
	EmailEnd:

	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// Initialize the MAPI library.
//.............................
int InitializeMAPI()
{
	if (lstrlen((LPCTSTR)&szMailClientDll) == 0)
	{
		return(ERR_NO_MAPIDLL);
	}
	if (!(hLibrary = LoadLibrary((LPCTSTR)&szMailClientDll)))
	{
		return(ERR_LOAD_LIB);
	}
	if (!(lpfnMAPILogon = (LPMAPILOGON)GetProcAddress(hLibrary,"MAPILogon")))
	{
		return(ERR_LOAD_FUNC);
	}
	if (!(lpfnMAPILogoff= (LPMAPILOGOFF)GetProcAddress(hLibrary,"MAPILogoff")))
	{
		return(ERR_LOAD_FUNC);
	}
	if (!(lpfnMAPISendMail= (LPMAPISENDMAIL)GetProcAddress(hLibrary,"MAPISendMail")))
	{
		return(ERR_LOAD_FUNC);
	}
	if (!(lpfnMAPISendDocuments= (LPMAPISENDDOCUMENTS)GetProcAddress(hLibrary,"MAPISendDocuments")))
	{
		return(ERR_LOAD_FUNC);
	}
	if (!(lpfnMAPIFindNext= (LPMAPIFINDNEXT)GetProcAddress(hLibrary,"MAPIFindNext")))
	{
		return(ERR_LOAD_FUNC);
	}
	if (!(lpfnMAPIReadMail= (LPMAPIREADMAIL)GetProcAddress(hLibrary,"MAPIReadMail")))
	{
		return(ERR_LOAD_FUNC);
	}
	if (!(lpfnMAPISaveMail= (LPMAPISAVEMAIL)GetProcAddress(hLibrary,"MAPISaveMail")))
	{
		return(ERR_LOAD_FUNC);
	}
	if (!(lpfnMAPIDeleteMail= (LPMAPIDELETEMAIL)GetProcAddress(hLibrary,"MAPIDeleteMail")))
	{
		return(ERR_LOAD_FUNC);
	}
	if (!(lpfnMAPIFreeBuffer= (LPMAPIFREEBUFFER)GetProcAddress(hLibrary,"MAPIFreeBuffer")))
	{
		return(ERR_LOAD_FUNC);
	}
	if (!(lpfnMAPIAddress= (LPMAPIADDRESS)GetProcAddress(hLibrary,"MAPIAddress")))
	{
		return(ERR_LOAD_FUNC);
	}
	if (!(lpfnMAPIDetails= (LPMAPIDETAILS)GetProcAddress(hLibrary,"MAPIDetails")))
	{
		return(ERR_LOAD_FUNC);
	}
	if (!(lpfnMAPIResolveName= (LPMAPIRESOLVENAME)GetProcAddress(hLibrary,"MAPIResolveName")))
	{
		return(ERR_LOAD_FUNC);
	}
	return(0);
}

// Deinitialize the MAPI Library.
//...............................
VOID DeInitializeMAPI()
{
	lpfnMAPILogon = NULL;
	lpfnMAPILogoff= NULL;
	lpfnMAPISendMail= NULL;
	lpfnMAPISendDocuments= NULL;
	lpfnMAPIFindNext= NULL;
	lpfnMAPIReadMail= NULL;
	lpfnMAPISaveMail= NULL;
	lpfnMAPIDeleteMail= NULL;
	lpfnMAPIFreeBuffer = NULL;
	lpfnMAPIAddress= NULL;
	lpfnMAPIDetails = NULL;
	lpfnMAPIResolveName;

	FreeLibrary(hLibrary);
}

// Logon to a MAPI mail session.
//..............................
BOOL LogonToMapi(DWORD dwHelp, BOOL bShowMsg, BOOL bHangup)
{
	BOOL			bResult = FALSE;
	ULONG			ulError;
	HMENU			hMenu;
	HCURSOR			hCurrentCursor = 0;
	DWORD			dwOldHelpTopic;
	FLAGS			fFlags = MAPI_LOGON_UI;

	// Make sure the rich edit background color is set to the default.
	//................................................................
	crBkgCurrent = GetSysColor(COLOR_WINDOW);

	// Switch the menu items for logging on and off. If we fail,
	// everything will be turned off.
	//..........................................................
	hMenu = GetMenu(hMainWindow);
	EnableMenuItem(hMenu,IDM_LOGOFF,MF_ENABLED | MF_BYCOMMAND);
	EnableMenuItem(hMenu,IDM_LOGON,MF_GRAYED | MF_BYCOMMAND);

	// Change the help topic.
	//.......................
	dwOldHelpTopic = ChangeHelpTopic(dwHelp);

	// If we want to download messages do so.
	//.......................................
	if (cfg.dwDownloadMessages)
	{
		fFlags ^= MAPI_FORCE_DOWNLOAD;
	}
	// Set the cursor to the wait cursor.
	//...................................
	hCurrentCursor = SetCursor(hCursorWait);

	// Only logon if lHandle is 0.
	//............................
	if (!lHandle)
	{
		// Display the logon dialog box.
		//..............................
		hDlgCurrent = CreateDialog(hInst,TEXT("LOGONMAPI"),hMainWindow,
								  (DLGPROC)CenterDlgBoxProc);

		if (!hDlgCurrent)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto LogonEnd;
		}
		
		ulError = MAPILogon((ULONG)hMainWindow,NULL,NULL,fFlags,0,&lHandle);

		// Destroy the modless dialog box.
		//................................
		DestroyWindow(hDlgCurrent);
		hDlgCurrent = 0;

		if (ulError == SUCCESS_SUCCESS)
		{
			bLoggedOn = TRUE;
			bResult = TRUE;
			if (bShowMsg)
			{
				MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_LOGONOK,
							   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
			}
		}
		else
		{
			SetLastError(ulError + MAPI_BASE);
			ErrorProcedure(lpMapiDllName,IDS_MAPI_LOGON,MB_OK);
			TurnOffMAPI();
		}
	}
	else
	{
		MessageBoxProc(hMainWindow,IDS_PROGRAM_ERROR,IDS_MAPI_HANDLE_ERR,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		TurnOffMAPI();
	}
		
	LogonEnd:

	if (hCurrentCursor)
	{
		SetCursor(hCurrentCursor);
	}
	ChangeHelpTopic(dwOldHelpTopic);

	EmptyTheMessageQue();
	if (bHangup)
	{
		HangUp(hMainWindow);
		EmptyTheMessageQue();
	}
	return(bResult);
}

// Lofoff from a MAPI mail session.
//.................................
VOID LogoffFromMapi(BOOL bShowMsg, BOOL bHangup)
{
	ULONG		ulError;
	HMENU		hMenu;
	HCURSOR		hCurrentCursor = 0;

	// Switch the menu items for logging on and off. If we fail,
	// everything will be turned off.
	//..........................................................
	hMenu = GetMenu(hMainWindow);
	EnableMenuItem(hMenu,IDM_LOGOFF,MF_GRAYED | MF_BYCOMMAND);
	EnableMenuItem(hMenu,IDM_LOGON,MF_ENABLED | MF_BYCOMMAND);

	hCurrentCursor = SetCursor(hCursorWait);
	if (lHandle)
	{
		ulError = MAPILogoff(lHandle,(ULONG)hMainWindow,0,0);
		SetCursor(hCurrentCursor);

		if (ulError != SUCCESS_SUCCESS)
		{
			SetLastError(ulError + MAPI_BASE);
			ErrorProcedure(lpMapiDllName,IDS_MAPI_LOGOFF,MB_OK);
			TurnOffMAPI();
		}
		else
		{
			bLoggedOn = FALSE;
			lHandle = 0;
			if (bShowMsg)
			{
				MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_LOGOFFOK,
							   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
			}
		}
	}
	EmptyTheMessageQue();
	
	if (bHangup)
	{
		HangUp(hMainWindow);
		EmptyTheMessageQue();
	}
}

// Popup the Address Book.
//........................
VOID GetTheAddressBook()
{
	lpMapiRecipDesc		lpNewRecips = 0;
	BOOL				bResult;
	ULONG				ulError;
	DWORD				dwOldHelpTopic;

	bProcessInProgress = TRUE;

	dwOldHelpTopic = ChangeHelpTopic(IDH_ADDRESSBOOK);

	// If we are not logged on do so.
	//...............................
	if (!bLoggedOn)
	{
		bResult = LogonToMapi(IDH_ADDRESSBOOK,FALSE,FALSE);
		if (!bResult)
		{
			goto AddressEnd;
		}
	}
	// Display the address book.
	//..........................
	bAddressBookDisplayed = TRUE;
	ulError = MAPIAddress(lHandle,(ULONG)hMainWindow,NULL,0,NULL,0,NULL,0,0,0,
						  &lpNewRecips);
	if (ulError == SUCCESS_SUCCESS || ulError == MAPI_USER_ABORT)
	{
		ulError = MAPIFreeBuffer(lpNewRecips);
		if (ulError != SUCCESS_SUCCESS && lpNewRecips)
		{
			SetLastError(ulError + MAPI_BASE);
			ErrorProcedure(lpMapiDllName,IDS_MAPI_FREEBUFFER,MB_OK);
			TurnOffMAPI();
		}
	}
	else
	{
		SetLastError(ulError + MAPI_BASE);
		ErrorProcedure(lpMapiDllName,IDS_MAPI_ADDRESS,MB_OK);
	}
	bAddressBookDisplayed = FALSE;

	AddressEnd:

	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// E-mail support request.
//........................
VOID EmailSupportRequest()
{
	MapiMessage			msgSend;
	MapiRecipDesc		Recips;
	BOOL				bResult;
	ULONG				ulError;
	DWORD				dwOldHelpTopic;
	TCHAR				szSupportMsg[1024];
	TCHAR				szFormatString[512];
	TCHAR				szTotal[24];
	TCHAR				szAvailable[24];
	MEMORYSTATUS		ms;
	int					x, y;

	bProcessInProgress = TRUE;

	dwOldHelpTopic = ChangeHelpTopic(IDH_SUPPORTEMAIL);

	if (!bLoggedOn)
	{
		bResult = LogonToMapi(IDH_SUPPORTEMAIL,FALSE,FALSE);
		if (!bResult)
		{
			goto SupportEnd;
		}
	}
	ZeroMemory(&msgSend,sizeof(MapiMessage));
	ZeroMemory(&Recips,sizeof(MapiRecipDesc));
	ZeroMemory(&szSupportMsg,sizeof(szSupportMsg));
	ZeroMemory(&szFormatString,sizeof(szFormatString));

	// Start building the message structure.
	//......................................
	Recips.lpszName = TEXT("Top Secret Crypto Gold Support");
	Recips.lpszAddress = TEXT("support@topsecretcrypto.com");
	Recips.ulRecipClass = 1;
	msgSend.lpRecips = &Recips;
	msgSend.nRecipCount = 1;
	msgSend.lpszSubject = TEXT("Support Request for Top Secret Crypto Gold v3.70");

	// Get the memory status.
	//.......................
	GlobalMemoryStatus(&ms);
	FormatMyNumber(ms.dwTotalPhys,(LPTSTR)&szTotal,sizeof(szTotal));
	FormatMyNumber(ms.dwAvailPhys,(LPTSTR)&szAvailable,sizeof(szAvailable));

	// Get the display resolution.
	//............................
	x = GetSystemMetrics(SM_CXSCREEN);
	y = GetSystemMetrics(SM_CYSCREEN);
	
	// Get the information to start the body of the message.
	//......................................................
	LoadString(hInst,IDS_SUPPORTMSG,(LPTSTR)&szFormatString,sizeof(szFormatString));
	StringCbPrintf((LPTSTR)&szSupportMsg,sizeof(szSupportMsg),(LPCTSTR)&szFormatString,
					szOSName,szTotal,szAvailable,x,y,szMailClient,szMailClientDll,
					dwSlwapiMajor,dwSlwapiMinor,dwMajor,dwMinor,dwShellMajor,dwShellMinor);
	msgSend.lpszNoteText = (LPTSTR)&szSupportMsg;

	ulError = MAPISendMail(lHandle,(ULONG)hMainWindow,&msgSend,MAPI_DIALOG,0L);
	if (ulError != SUCCESS_SUCCESS)
	{
		if (ulError != MAPI_E_USER_ABORT)
		{
			SetLastError(ulError + MAPI_BASE);
			ErrorProcedure(lpMapiDllName,IDS_MAPI_SEND_MAIL,MB_OK);
		}
	}

	SupportEnd:

	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// Compose a regular e-mail message.
//..................................
VOID ComposeRegularMail()
{
	MapiMessage			msgSend;
	BOOL				bResult;
	ULONG				ulError;
	DWORD				dwOldHelpTopic;

	bProcessInProgress = TRUE;

	dwOldHelpTopic = ChangeHelpTopic(IDH_COMPOSEMAIL);

	if (!bLoggedOn)
	{
		bResult = LogonToMapi(IDH_COMPOSEMAIL,FALSE,FALSE);
		if (!bResult)
		{
			goto ComposeEnd;
		}
	}
	ZeroMemory(&msgSend,sizeof(MapiMessage));

	ulError = MAPISendMail(lHandle,(ULONG)hMainWindow,&msgSend,MAPI_DIALOG,0L);
	if (ulError != SUCCESS_SUCCESS)
	{
		SetLastError(ulError + MAPI_BASE);
		ErrorProcedure(lpMapiDllName,IDS_MAPI_SEND_MAIL,MB_OK);
	}
	
	ComposeEnd:

	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// PvAlloc
//
// Purpose: Allocates a chunk of memory on the global heap.
//
// Parameters:
//      cbSize          - Count of bytes requested.
//
//  Returns:
//      lpv             - Pointer to the allocated memory.
//.........................................................
LPBYTE PvAlloc(ULONG cbSize)
{
    LPBYTE		lpv = NULL;
    HANDLE		hMem;
    PPVINFO		ppvinfo;

    // Make sure allocations are in multiples of 4.
	//.............................................
    if(cbSize < 4)
	{
        cbSize = 4;
	}
    else if(cbSize & 3)
	{
        cbSize += 4 - (cbSize & 3);
	}

    // Allocate the block.
	//....................
    hMem = GlobalAlloc(GMEM_MOVEABLE, cbSize + sizeof(PVINFO));
    if(hMem)
    {
        ppvinfo = (PPVINFO)GlobalLock(hMem);
        ppvinfo->hMem    = hMem;
		ppvinfo->cbSize  = cbSize;
        ppvinfo->lpvNext = NULL;
        ppvinfo->lpvBuf  = ((PB)ppvinfo) + sizeof(PVINFO);
        lpv = ppvinfo->lpvBuf;
    }
	else
	{
		ErrorProcedure(lpMapiFunction,IDS_ALLOCATEMEMORY,MB_OK);
	}
    return (lpv);
}

// PvAllocMore
//
//  Purpose: Allocates a chunk of memory and chains it to a parent block.
//
//  Parameters:
//      cbSize          - Count of additional bytes to allocate.
//      lpvParent       - Pointer to parent in memory chain.
//
//  Returns:
//      lpv             - Pointer to the allocated memory.
//.......................................................................
LPBYTE PvAllocMore(ULONG cbSize, LPBYTE lpvParent)
{
    LPBYTE		lpvStep = lpvParent;
    LPBYTE		lpv = NULL;
    PPVINFO     ppvinfoMore;
    HANDLE      hMem;
    PPVINFO     ppvinfo;

    // Step to the last link.
	//.......................
    do
    {
        ppvinfoMore = (PPVINFO)(((LPBYTE)lpvStep) - sizeof(PVINFO));
        lpvStep = ppvinfoMore->lpvNext;
    }
    while(ppvinfoMore->lpvNext != NULL);

    // Beginning of section that was taken from PvAlloc.
	//..................................................
    if(cbSize < 4)
	{
		cbSize = 4;
	}
    else if(cbSize & 3)
	{
        cbSize += 4 - (cbSize & 3);
	}
    hMem = GlobalAlloc(GMEM_MOVEABLE, cbSize + sizeof(PVINFO));
    if(hMem)
    {
        ppvinfo = (PPVINFO)GlobalLock(hMem);
        ppvinfo->hMem       = hMem;
		ppvinfo->cbSize		= cbSize;
        ppvinfo->lpvNext    = NULL;
        ppvinfo->lpvBuf     = ((PB)ppvinfo) + sizeof(PVINFO);
        lpv = ppvinfo->lpvBuf;
		FillMemory(lpv,cbSize,0xbb);
		ppvinfoMore->lpvNext = lpv;
    }
    else
	{
		ErrorProcedure(lpMapiFunction,IDS_ALLOCATEMEMORY,MB_OK);
	}

    return (lpv);
}

// PvFree
//
//  Purpose:
//      This function frees memory allocated by PvAlloc or PvAllocMore.
//      After the call, the pointer memory will be invalid and should
//      not be referenced again.
//      When memory is allocated by PvAlloc and PvAllocMore, which can
//      contain several levels of pointers, all the application needs to
//      do to free the entire structure is call this routine with the
//      base pointer returned by the PvAlloc call.
//
//  Parameters:
//      lpv             - Pointer to memory to be freed.
//
//  Returns:
//      BOOL
//......................................................................
BOOL PvFree(LPBYTE lpv)
{
    PPVINFO ppvinfo;

    if(!lpv)
	{
        return 0;
	}
    ppvinfo = (PPVINFO)(((LPBYTE)lpv) - sizeof(PVINFO));

    while(ppvinfo)
    {
        lpv = ppvinfo->lpvNext;

		// Zero the memory block.
		//.......................
		ZeroMemory(ppvinfo->lpvBuf,ppvinfo->cbSize);

        if(GlobalUnlock(ppvinfo->hMem))
		{
            goto err;			// Our lock count is non-zero.
		}
        if(GlobalFree(ppvinfo->hMem))
		{
            goto err;			// Failure
		}
        if(lpv)
		{
            ppvinfo = (PPVINFO)(((LPBYTE)lpv) - sizeof(PVINFO));
		}
        else
		{
            break;
		}
    }
    return 0;		// Success!

	err:

	ErrorProcedure(lpMapiFunction,IDS_DEALLOCATEMEM,MB_OK);

    return 1;		// Failure!
}

// MakeDisplayNameStr
//
//  Purpose:
//      Finds all recipients of type ulRecipClass in lpRecips and adds
//      their friendly name to the display string.
//
//  Parameters:
//      lpszDisplay         - Destination string for names.
//      ulRecipClass        - Recipient types to search for.
//      cRecips             - Count of recipients in lpRecips.
//      lpRecips            - Pointer to array of MapiRecipDescs.
//
//  Return:
//      BOOL.
//.....................................................................
BOOL MakeDisplayNameStr(HWND hWnd, LPTSTR lpszDisplay, ULONG ulRecipClass,
						ULONG cRecips, lpMapiRecipDesc lpRecips)
{
    ULONG		idx;
	HRESULT		hResult;
	BOOL		bErr = FALSE;

    *lpszDisplay = '\0';

    for (idx = 0; idx < cRecips; idx++)
    {
		if (lpRecips[idx].ulRecipClass == ulRecipClass)
		{
			hResult = StringCbCatEx(lpszDisplay,TO_EDIT_MAX,lpRecips[idx].lpszName,NULL,
									NULL,dwStringSafeFlag);
			if (hResult < 0)
			{
				bErr = TRUE;
				break;
			}
			hResult = StringCbCatEx(lpszDisplay,TO_EDIT_MAX,"; ",NULL,NULL,
									dwStringSafeFlag);
			if (hResult < 0)
			{
				bErr = TRUE;
				break;
			}
		}
    }
    if (*lpszDisplay)
	{
		lpszDisplay[lstrlen(lpszDisplay) - 2] = '\0';
	}
	if (bErr)
	{
		MessageBoxProc(hWnd,IDS_PROGRAMLIMIT,(ulRecipClass + (IDS_MAPITO - 1)),
					   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
	}
	return(bErr);
}

// ResolveFriendlyNames
//
//  Purpose:
//      Helper function to convert a string of ';' delimited friendly
//      names into an array of MapiRecipDescs.
//
//  Side Effects:                                             
//      The display string passed in is modified to contain the
//      friendly names of the mail users as found in the sample
//      address book.
//
//  Note:
//      Duplicate names in the address book will result in undefined
//      behavior.
//
//  Parameters:
//      hWnd                - Handle to parent window.
//      lpszDisplayNames    - string of ';' delimited user names.
//      ulRecipClass        - either MAPI_TO, MAPI_CC, or MAPI_BCC.
//      lpcRecips           - Address of recipient count to be returned.
//      lppRecips           - Address of recipient array to be returned.
//
//  Return:
//      ulResult.
//......................................................................
ULONG ResolveFriendlyNames(HWND hWnd, LPSTR lpszDisplayNames, ULONG ulRecipClass,
						   ULONG * lpcRecips, lpMapiRecipDesc * lppRecips)
{
    char			szResolve[TO_EDIT_MAX];
    LPSTR			lpszNameToken;
    ULONG			cRecips = 0;
    ULONG			cFails = 0;
    ULONG			ulResult;
    lpMapiRecipDesc lpRecip;
    lpMapiRecipDesc lpRecipList;

    *szResolve = '\0';
    lpszNameToken = strtok(lpszDisplayNames,";\n");

    while (lpszNameToken)
    {
		// Strip leading blanks from name.
		//................................
		while (*lpszNameToken == ' ')
		{
			lpszNameToken++;
		}

		// Check if name has already been resolved.
		//.........................................
		if (!FNameInList(lpszNameToken,*lpcRecips,*lppRecips))
		{
			StringCbCatEx(szResolve,sizeof(szResolve),lpszNameToken,NULL,NULL,
						  dwStringSafeFlag);
			StringCbCatEx(szResolve,sizeof(szResolve), "; ",NULL,NULL,dwStringSafeFlag);
			cRecips++;
		}
		// Get Next Token.
		//................
		lpszNameToken = strtok(NULL,";\n");
	}
	*lpszDisplayNames = '\0';

	if (!szResolve[0])
	{
		ulResult = SUCCESS_SUCCESS;
		goto err;
	}
	szResolve[lstrlen(szResolve) - 2] = '\0';

	lpRecipList = (lpMapiRecipDesc)PvAlloc((cRecips + *lpcRecips) * sizeof(MapiRecipDesc));

	if (!lpRecipList)
	{
		ulResult = MAPI_E_INSUFFICIENT_MEMORY;
		goto err;
	}
	ZeroMemory(lpRecipList,(cRecips + *lpcRecips) * sizeof(MapiRecipDesc));

	cRecips = 0;

	while (cRecips < *lpcRecips)
	{
		ulResult = CopyRecipient(lpRecipList,&lpRecipList[cRecips],*lppRecips + cRecips);

		if (ulResult)	
		{
			PvFree((LPBYTE)lpRecipList);
			goto err;
		}
		cRecips++;
    }
    PvFree((LPBYTE)*lppRecips);

    lpszNameToken = strtok(szResolve,";\n");

    while (lpszNameToken)
    {
		// Strip leading blanks (again).
		//..............................
		while (*lpszNameToken == ' ')
		{
			lpszNameToken++;
		}
		ulResult = MAPIResolveName(lHandle,(ULONG)hWnd,lpszNameToken,MAPI_DIALOG,0,&lpRecip);

		if (ulResult == SUCCESS_SUCCESS)
		{
			lpRecip->ulRecipClass = ulRecipClass;
			ulResult = CopyRecipient(lpRecipList,&lpRecipList[cRecips],lpRecip);

			MAPIFreeBuffer(lpRecip);

			if (ulResult)
			{
				goto cleanup;
			}
			cRecips++;
		}
		else
		{
			StringCbCatEx(lpszDisplayNames,TO_EDIT_MAX,lpszNameToken,NULL,NULL,
						  dwStringSafeFlag);
			StringCbCatEx(lpszDisplayNames,TO_EDIT_MAX,"; ",NULL,NULL,dwStringSafeFlag);
			cFails++;
		}
		lpszNameToken = strtok(NULL,";\n");
    }
    // if cFails > 0 then we have partial success.
	//............................................
    ulResult = SUCCESS_SUCCESS;

    if (cFails)
	{
		MessageBoxProc(hWnd,IDS_MAPI_RES_NAME,IDS_MAPI_UNRESNAMES,MB_ICONINFORMATION | MB_OK,
					   MB_ICONINFORMATION,0);
	}

	cleanup:

    *lpcRecips = cRecips;
    *lppRecips = lpRecipList;

	err:

    if (*lpszDisplayNames)
	{
		lpszDisplayNames[lstrlen (lpszDisplayNames) - 2] = '\0';
	}
    return ulResult;
}

// CopyRecipient
//
//  Purpose:
//      Called in support of ResolveFriendlyNames() to build an array
//      of chained MapiRecipDescs.
//
//  Parameters:
//      lpParent        - Parent memory that allocations get chained to.
//      lpDest          - Destination Recipient.
//      lpSrc           - Source Recipient.
//
//  Return:
//      ulResult
//......................................................................
ULONG CopyRecipient(lpMapiRecipDesc lpParent, lpMapiRecipDesc lpDest, lpMapiRecipDesc lpSrc)
{
    lpDest->ulReserved = lpSrc->ulReserved;
    lpDest->ulRecipClass = lpSrc->ulRecipClass;
    lpDest->ulEIDSize = lpSrc->ulEIDSize;

    if (lpSrc->lpszName)
    {
		lpDest->lpszName = (LPTSTR)PvAllocMore(lstrlen(lpSrc->lpszName) + 1,
						   (LPVOID)lpParent);

		if (!lpDest->lpszName)	
		{
			return MAPI_E_INSUFFICIENT_MEMORY;
		}
		StringCbCopy(lpDest->lpszName,(lstrlen(lpSrc->lpszName) + 1),lpSrc->lpszName);
    }
    else
	{
		lpDest->lpszName = NULL;
	}
    if (lpSrc->lpszAddress)
    {
		lpDest->lpszAddress = (LPTSTR)PvAllocMore(lstrlen(lpSrc->lpszAddress) + 1,
							  (LPVOID)lpParent);

		if (!lpDest->lpszAddress)
		{
			return MAPI_E_INSUFFICIENT_MEMORY;
		}
		StringCbCopy(lpDest->lpszAddress,(lstrlen(lpSrc->lpszAddress) + 1),
					 lpSrc->lpszAddress);
    }
    else
	{
		lpDest->lpszAddress = NULL;
	}
    if (lpSrc->lpEntryID)
    {
		lpDest->lpEntryID = (LPBYTE)PvAllocMore(lpSrc->ulEIDSize,(LPVOID)lpParent);

		if (!lpDest->lpEntryID)
		{
			return MAPI_E_INSUFFICIENT_MEMORY;
		}
        if (lpSrc->ulEIDSize)
		{
            memcpy(lpDest->lpEntryID,lpSrc->lpEntryID,(size_t)lpSrc->ulEIDSize);
		}
    }
    else
	{
		lpDest->lpEntryID = NULL;
	}

    return SUCCESS_SUCCESS;
}

// FNameInList
//
//  Purpose:
//      To find lpszName in an array of recipients.  Used to determine
//      if user name has already been resolved.
//
//  Parameters:
//      lpszName        - Friendly name to search for.
//      cRecips         - Count of recipients in lpRecips.
//      lpRecips        - Array of MapiRecipDescs.
//
//  Return:
//      TRUE/FALSE
//....................................................................
BOOL FNameInList(LPSTR lpszName, ULONG cRecips, lpMapiRecipDesc lpRecips)
{
    // Case sensitive compare of each friendly name in list.
	//......................................................
    if (!cRecips || !lpRecips)
	{
		return FALSE;
	}

    while (cRecips--)
	{
		if (!lstrcmp(lpszName,lpRecips[cRecips].lpszName))
		{
			return TRUE;
		}
	}

    return FALSE;
}

// Select a character font for the richedit text control.
//.......................................................
VOID SelectCharFormat(HWND hDlg, HWND hControl, LPBYTE lpFont)
{
	LOGFONT			lf;
	CHOOSEFONT		csf;
	CHARFORMAT2		cf1;
	LONG			yPerInch;
	HDC				hdc;
	UINT			uCheck;

	ZeroMemory(&cf1,sizeof(CHARFORMAT2));
	ZeroMemory(&lf,sizeof(LOGFONT));
	ZeroMemory(&csf,sizeof(CHOOSEFONT));

	cf1.cbSize = sizeof(CHARFORMAT2);

	hdc = GetDC(hControl);
	yPerInch = GetDeviceCaps(hdc,LOGPIXELSY);
	ReleaseDC(hControl,hdc);

	lpIconPointer = lpszAppName;

	// Get the current font information from the rich edit control.
	//.............................................................
	SendMessage(hControl,EM_GETCHARFORMAT,(WPARAM)TRUE,(LPARAM)&cf1);

	// Setup the choose font structure.
	//.................................
	csf.lStructSize = sizeof(csf);
	csf.hwndOwner = hDlg;
	csf.hDC = 0;
	csf.lpLogFont = &lf;
	csf.Flags = CF_EFFECTS | CF_SCREENFONTS | CF_INITTOLOGFONTSTRUCT | CF_SHOWHELP | CF_ENABLEHOOK;
	csf.rgbColors = crTextCurrent;
	csf.lpszStyle = NULL;
	csf.nFontType = REGULAR_FONTTYPE | SCREEN_FONTTYPE;
	csf.lpfnHook = MyCFHookProc;

	// Setup the log font structure.
	//..............................
	lf.lfHeight = -(INT) ((cf1.yHeight * yPerInch) / 1440);
	lf.lfWidth = 0;
	lf.lfEscapement = 0;
	lf.lfOrientation = 0;
	lf.lfWeight = (cf1.dwEffects & CFE_BOLD) ? FW_BOLD : FW_NORMAL;
	lf.lfItalic = (cf1.dwEffects & CFE_ITALIC) ? TRUE : FALSE;
	lf.lfUnderline = (cf1.dwEffects & CFE_UNDERLINE) ? TRUE : FALSE;
	lf.lfStrikeOut = (cf1.dwEffects & CFE_STRIKEOUT) ? TRUE : FALSE;
	lf.lfOutPrecision = OUT_DEFAULT_PRECIS;
	lf.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	lf.lfQuality = DRAFT_QUALITY;
	lf.lfCharSet = cf1.bCharSet;
	lf.lfPitchAndFamily = cf1.bPitchAndFamily;
	StringCbCopy(lf.lfFaceName,LF_FACESIZE,cf1.szFaceName);

	// Go and get the font selection.
	//...............................
	if(!ChooseFont(&csf))
	{
		CommDlgBoxErrorProc(IDS_FONTS);
	}
	else
	{
		cf1.cbSize = sizeof(CHARFORMAT2);

		// Don't change read-only bit.
		//............................
		cf1.dwMask = CFM_SIZE | CFM_BOLD | CFM_ITALIC | CFM_STRIKEOUT | 
			        CFM_UNDERLINE | CFM_COLOR | CFM_FACE | CFM_CHARSET;
		cf1.yHeight = (LONG) csf.iPointSize * 2;
		cf1.dwEffects = CFE_BOLD | CFE_ITALIC | CFE_STRIKEOUT | CFE_UNDERLINE;
		if(lf.lfWeight < FW_BOLD)
		{
			cf1.dwEffects &= ~CFE_BOLD;
		}
		if(!lf.lfItalic)
		{
			cf1.dwEffects &= ~CFE_ITALIC;
		}
		if(!lf.lfUnderline)
		{
			cf1.dwEffects &= ~CFE_UNDERLINE;
		}
		if(!lf.lfStrikeOut)
		{
			cf1.dwEffects &= ~CFE_STRIKEOUT;
		}
		cf1.crTextColor = csf.rgbColors;
		crTextCurrent = csf.rgbColors;
		cf1.bCharSet = lf.lfCharSet;
		cf1.bPitchAndFamily = lf.lfPitchAndFamily;
		StringCbCopy(cf1.szFaceName,LF_FACESIZE,lf.lfFaceName);

		if(!SendMessage(hControl,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cf1))
		{
			SendMessage(hControl,EM_SETCHARFORMAT,0,(LPARAM)&cf1);
		}
		else
		{
			// Save the new settings.
			//.......................
			CopyMemory(lpFont,&cf1,sizeof(CHARFORMAT2));

			// Set the required radiobuttons to their required settings.
			//..........................................................
			uCheck = BST_UNCHECKED;
			if (lf.lfItalic)
			{
				uCheck = BST_CHECKED;
			}
			CheckDlgButton(hDlg,IDC_ITALIC,uCheck);

			uCheck = BST_UNCHECKED;
			if (lf.lfUnderline)
			{
				uCheck = BST_CHECKED;
			}
			CheckDlgButton(hDlg,IDC_UNDERLINE,uCheck);

			uCheck = BST_CHECKED;
			if (lf.lfWeight < FW_BOLD)
			{
				uCheck = BST_UNCHECKED;
			}
			CheckDlgButton(hDlg,IDC_BOLD,uCheck);
		}
		SetFocus(hControl);

		// Check on the status of the text color button.
		//..............................................
		if (bNoTextClr)
		{
			EnableWindow(GetDlgItem(hDlg,IDC_TEXTCLR),TRUE);
			bNoTextClr = FALSE;
		}
	}
}

// Update the radio buttons depending on the situation.
//.....................................................
VOID UpdateRtfRadioButtons(HWND hDlg, UINT uIdRtf)
{
	UINT					uCheck1;
	UINT					uCheck2;
	int						iCheck;

	// Get the current paragraph and character formating.
	//...................................................
	pf.cbSize = sizeof(PARAFORMAT2);
	cf.cbSize = sizeof(CHARFORMAT2);

	SendDlgItemMessage(hDlg,uIdRtf,EM_GETPARAFORMAT,0,(LPARAM)&pf);
	SendDlgItemMessage(hDlg,uIdRtf,EM_GETCHARFORMAT,1,(LPARAM)&cf);

	// Take care of the bold setting.
	//...............................
	if (cf.dwMask & CFM_BOLD)
	{	
		uCheck1 = IsDlgButtonChecked(hDlg,IDC_BOLD);
		uCheck2 = BST_UNCHECKED;
		if (cf.dwEffects & CFE_BOLD)
		{
			uCheck2 = BST_CHECKED;
		}
		if (uCheck1 != uCheck2)
		{
			CheckDlgButton(hDlg,IDC_BOLD,uCheck2);
		}
	}
	// Take care of the italic setting.
	//.................................
	if (cf.dwMask & CFM_ITALIC)
	{	
		uCheck1 = IsDlgButtonChecked(hDlg,IDC_ITALIC);
		uCheck2 = BST_UNCHECKED;
		if (cf.dwEffects & CFE_ITALIC)
		{
			uCheck2 = BST_CHECKED;
		}
		if (uCheck1 != uCheck2)
		{
			CheckDlgButton(hDlg,IDC_ITALIC,uCheck2);
		}
	}
	// Take care of the underline setting.
	//....................................
	if (cf.dwMask & CFM_UNDERLINE)
	{	
		uCheck1 = IsDlgButtonChecked(hDlg,IDC_UNDERLINE);
		uCheck2 = BST_UNCHECKED;
		if (cf.dwEffects & CFE_UNDERLINE)
		{
			uCheck2 = BST_CHECKED;
		}
		if (uCheck1 != uCheck2)
		{
			CheckDlgButton(hDlg,IDC_UNDERLINE,uCheck2);
		}
	}
	// Take care of the paragraph alignment.
	//......................................
	if (pf.dwMask & PFM_ALIGNMENT)
	{
		if (pf.wAlignment == PFA_LEFT)
		{
			iCheck = IDC_LEFT;
		}
		else if (pf.wAlignment == PFA_CENTER)
		{
			iCheck = IDC_CENTER;
		}
		else if (pf.wAlignment == PFA_RIGHT)
		{
			iCheck = IDC_RIGHT;
		}
		CheckRadioButton(hDlg,IDC_LEFT,IDC_RIGHT,iCheck);
	}
	// Take care of the bullets radiobutton.
	//......................................
	if (pf.dwMask & PFM_NUMBERING)
	{
		uCheck2 = BST_UNCHECKED;

		if (pf.wNumbering >= PFN_BULLET && pf.wNumbering <= 6)
		{
			uCheck2 = BST_CHECKED;
		}
		uCheck1 = IsDlgButtonChecked(hDlg,IDC_BULLETS);
		if (uCheck1 != uCheck2)
		{
			CheckDlgButton(hDlg,IDC_BULLETS,uCheck2);
		}
	}
}

// Hook procedure for selecting a font.
//.....................................
UINT CALLBACK MyCFHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uiMsg)
	{
		case WM_INITDIALOG:
		{
			SendMessage(hDlg,WM_SETTEXT,0,
				       (LPARAM)TEXT("Select a Font for the Rich Text Edit Control"));
			SetMyIcon(hDlg);
			CenterWindow(hDlg,hMainWindow);
			return(TRUE);
		}
	}
	return(FALSE);
}

// Hook procedure for selecting background color.
//...............................................
UINT CALLBACK MyCCHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uiMsg)
	{
		case WM_INITDIALOG:
		{
			if (bChooseHighLightColor)
			{
				SendMessage(hDlg,WM_SETTEXT,0,
						   (LPARAM)TEXT("Select a Highlight Color"));
			}
			else
			{
				if (bChooseBkgColor)
				{
					SendMessage(hDlg,WM_SETTEXT,0,
							   (LPARAM)TEXT("Select a Background Color"));
				}
				else
				{
					SendMessage(hDlg,WM_SETTEXT,0,
							   (LPARAM)TEXT("Select a Text Color"));
				}
			}
			SetMyIcon(hDlg);
			CenterWindow(hDlg,hMainWindow);
			return(TRUE);
		}
	}
	return(FALSE);
}

// Open a file for streaming into a rich edit text control.
//.........................................................
BOOL OpenFileStreamIn(LPTSTR lpFileName, HWND hDlg, int iIDRtf, int iAttrib)
{
	BOOL		bErr = TRUE;
	HANDLE		hFile = 0;
	EDITSTREAM	eStream;
	HWND		hRtf;

	hRtf = GetDlgItem(hDlg,iIDRtf);

	hFile = CreateMyFile(lpFileName,GENERIC_READ,0,NULL,OPEN_EXISTING,
						 FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hFile)
	{
		goto StreamEnd;
	}
	eStream.dwCookie = (DWORD)hFile;
	eStream.dwError = 0;
	eStream.pfnCallback = EditStreamInCallback;

	SendMessage(hRtf,EM_STREAMIN,(WPARAM)iAttrib,(LPARAM)&eStream);

	// Get the result of the operation.
	//.................................
	if (!eStream.dwError)
	{
		bErr = FALSE;

		// Reset the dirty bit.
		//.....................
		SendMessage(hRtf,EM_SETMODIFY,(WPARAM)TRUE,0);
	}
	else
	{
		SetLastError(IDS_RTFSTREAMINERROR);
		ErrorProcedure(lpszRTF,IDS_RTFSTREAMIN,MB_OK);
	}
	
	StreamEnd:

	if (hFile)
	{
		CloseMyHandle(lpFileName,hFile);
	}
	return(bErr);
}

// Callback function for streaming the data into the rich text window.
//....................................................................
DWORD CALLBACK EditStreamInCallback(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG FAR *pcb)
{
	BOOL		bResult;

	bResult = ReadMyFile((LPTSTR)&szDestination,(HANDLE)dwCookie,pbBuff,cb,pcb,NULL);
	if (!bResult)
	{
		return(1);			// Error indicator.
	}
	return(0);
}

// Create a file for streaming rich text out of a rtf control.
//............................................................
BOOL CreateFileStreamOut(LPTSTR lpFileName, HWND hDlg, int iIDRtf, UINT uFormat, BOOL bDefault)
{
	BOOL		bResult = FALSE;
	HANDLE		hFile = 0;
	EDITSTREAM	eStream;
	HWND		hRtf;

	hRtf = GetDlgItem(hDlg,iIDRtf);

	if (bDefault)
	{
		ZeroMemory(lpFileName,MAX_PATH);
		GetTempPath(MAX_PATH,lpFileName);
		StringCbCatEx(lpFileName,MAX_PATH,(LPCTSTR)&szClipboardRtf,NULL,NULL,
					  dwStringSafeFlag);
	}
	hFile = CreateMyFile(lpFileName,GENERIC_READ | GENERIC_WRITE,0,NULL,
					     CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hFile)
	{
		goto StreamEnd;
	}
	eStream.dwCookie = (DWORD)hFile;
	eStream.dwError = 0;
	eStream.pfnCallback = EditStreamOutCallback;

	SendMessage(hRtf,EM_STREAMOUT,(WPARAM)uFormat,(LPARAM)&eStream);

	// Get the result of the operation.
	//.................................
	if (!eStream.dwError)
	{
		bResult = TRUE;

		// Reset the dirty bit.
		//.....................
		SendMessage(hRtf,EM_SETMODIFY,(WPARAM)TRUE,0);
	}
	else
	{
		SetLastError(IDS_RTFSTREAMOUTERROR);
		ErrorProcedure(lpszRTF,IDS_RTFSTREAMOUT,MB_OK);
	}
	
	StreamEnd:

	if (hFile)
	{
		CloseMyHandle(lpFileName,hFile);
	}
	return(bResult);
}

// Callback function for streaming the data out of a rich text window.
//....................................................................
DWORD CALLBACK EditStreamOutCallback(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG FAR *pcb)
{
	BOOL		bResult;

	bResult = WriteMyFile((LPTSTR)&szFileToEncipher,(HANDLE)dwCookie,pbBuff,cb,pcb,NULL);
	if (!bResult)
	{
		return(1);			// Error indicator.
	}
	return(0);
}

// GetNextFile
//
//  Purpose:
//      Called when user clicks 'Attach' button in Compose Note form.
//      We will build a chained memory chunk for mmore than one file
//      attachment so the memory can be freed with a single call to
//      PvFree.
//
//  Parameters:
//      hWnd            - Window handle of Compose Note dialog.
//      nPos            - Render position of attachment in Notetext.
//      lpcAttach       - Pointer to the count of attachments.
//      lppAttach       - Pointer to the MapiFileDesc array.
//
//  Return:
//      ulResult.
//...................................................................
ULONG GetNextFile(HWND hWnd, ULONG nPos, ULONG * lpcAttach, lpMapiFileDesc * lppAttach)
{
    lpMapiFileDesc		lpAttach = 0;
    lpMapiFileDesc		lpAttachT;
    OPENFILENAME		ofn;
	LPBYTE				lpFileReturn = 0;
	LPBYTE				lpOriginalFiles = 0;
	LPBYTE				lpTempFilePtr;
	LPBYTE				lpFileInsert;
	LPBYTE				lpFileExtension;
	LPBYTE				lpFileName;
    ULONG				idx;
	BOOL				bMoreThanOne;
	BOOL				bErr;
	ULONG				ulResult = MAPI_USER_ABORT;
	ULONG				ulNumberOfFiles;
	ULONG				ulTotalFiles;
	int					iFileNameLength;
	TCHAR				szFileName[MAX_PATH];

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	bWipeAfterAttach = FALSE;
	bCompressAndEncrypt = TRUE;

	// Allocate the memory for the return file buffer. This is
	// the maximum sized buffer that the GetOpenFileName common
	// dialog box procedure can handle.
	//.........................................................
	lpOriginalFiles = AllocateMemory((64 * 1024) - 1);
	if (!lpOriginalFiles)
	{
		goto FileEnd;
	}
	// Initialize with specific information for this procedure.
	//.........................................................
	ofn.lpstrFile = lpOriginalFiles;
	ofn.nMaxFile = ((64 * 1024) - 1);
	ofn.hwndOwner = hWnd;
	ofn.hInstance = hInst;
	ofn.lpstrFilter = TEXT("All Files [*.*]\0*.*\0Tscg Files [.rng;.rsakey;.tsc;.otp;.pad;.tsig;.jrl]\0*.rng;*.rsakey;*.tsc;*.otp;*.pad;*.tsig;*.jrl\0Compressed Files [.pkd;.lha;.zip;.arj]\0*.pkd;*.lha;*.zip;*.arj\0Adobe PDF Files [.pdf]\0*.pdf\0Executable Files [.exe;.dll;.ocx]\0*.exe;*.dll;*.ocx\0Image Files [.bmp;.dib;.gif;.jpg;,ico;,cur]\0*.bmp;*.dib;*.gif;*.jpg;*.ico;*.cur\0Word Documents [.doc]\0*.doc\0Web Pages [.htm;.html]\0*.htm;*.html\0Rich Text Format [.rtf]\0*.rtf\0Text Files [.txt]\0*.txt\0Lotus 1-2-3 [.wk1;.wk3]\0*.wk1;*.wk3\0Microsoft Excel Worksheet [.xls;.xlw]\0*.xls;*.xlw\0Windows Write [.wri]\0*.wri\0WordPerfect 5.x [.doc]\0*.doc\0WordPerfect 6.x [.wpd;.doc]\0*.wpd;*.doc\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Select One or More Attachments for Your Message");
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
			     OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | 
			     OFN_ALLOWMULTISELECT | OFN_HIDEREADONLY | OFN_ENABLETEMPLATE);
	ofn.lpstrDefExt = NULL;
	if (bWin2000OrGreater)
	{
		ofn.lpTemplateName = TEXT("WIPEAFTERATTACHNEW");
	}
	else
	{
		ofn.lpTemplateName = TEXT("WIPEAFTERATTACH");
	}
	ofn.lpfnHook = MyAttachOFNHookProc;
		
	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	// Select the files to backup.
	//............................
	if (!GetOpenFileName(&ofn))
	{
		CommDlgBoxErrorProc(IDS_GET_FILES);
		goto FileEnd;
	}
	// Save a copy of our original files.
	//...................................
	lpFileReturn = lpOriginalFiles;

	// If we want to compress and encrypt the files do it.
	//....................................................
	if (bCompressAndEncrypt)
	{
		bNeedDestination = TRUE;
		bPackingRequired = TRUE;
		bWipeIntermediate = TRUE;
		bErr = EncryptAFile(lpFileReturn,&ofn);
		if (bErr)
		{
			goto FileEnd;
		}
		lpFileReturn = (LPBYTE)&szDestination;
		ulTotalFiles = 1;
		ulNumberOfFiles = 1;
	}
	else
	{
		// Determine the number of files selected.
		//........................................
		lpTempFilePtr = (lpFileReturn + ofn.nFileOffset);
		ulNumberOfFiles = 0;
		while(TRUE)
		{
			if (*lpTempFilePtr == 0)
			{
				break;
			}
			iFileNameLength = lstrlen(lpTempFilePtr);
			ulNumberOfFiles++;

			// Point to the next file selected. Get past the
			// trailing null byte.
			//..............................................
			lpTempFilePtr += (int)(iFileNameLength + 1);
		}
		ulTotalFiles = ulNumberOfFiles;
	}
	// Setup the path for our selected files. If only 1 files
	// selected, we have the whole file spec.
	//.......................................................
	ZeroMemory(&szFileName,sizeof(szFileName));
	StringCbCatEx((LPTSTR)&szFileName,sizeof(szFileName),lpFileReturn,NULL,NULL,
				   dwStringSafeFlag);

	if(ulTotalFiles > 1)
	{
		SaveDirName((LPBYTE)&szFileName,SAVE_SOURCE,FALSE);
	}
	else
	{
		SaveDirName((LPBYTE)&szFileName,SAVE_SOURCE,TRUE);
	}
	// If we have more than one file we have to add a backslash.
	//.........................................................
	bMoreThanOne = FALSE;
	if (ulNumberOfFiles > 1)
	{
		bMoreThanOne = TRUE;
		lpFileInsert = PathAddBackslash((LPTSTR)&szFileName);
	}
	lpTempFilePtr = (lpFileReturn + ofn.nFileOffset);

	// Setup a new memory structure to hold the old and the new files.
	//................................................................
    lpAttach = (lpMapiFileDesc)PvAlloc(((*lpcAttach) + ulNumberOfFiles) * sizeof(MapiFileDesc));

    if(!lpAttach)
	{
		goto FileEnd;
	}
	ZeroMemory(lpAttach,(*lpcAttach + ulNumberOfFiles) * sizeof(MapiFileDesc));

	// Save the old list of files. Delete it if we have
	// a good new list.
	//.................................................
    lpAttachT = *lppAttach;

	// Copy the previous selections, if any to the new structure.
	//...........................................................
    for (idx = 0; idx < *lpcAttach; idx++)
	{
		if (ulResult = CopyAttachment(lpAttach,&lpAttach[idx],&lpAttachT[idx]))
		{
			goto FileEnd;
		}
	}
	// We always fail.
	//................
	ulResult = MAPI_USER_ABORT;

	// Process all the newly selected files.
	//......................................
	while(ulNumberOfFiles > 0)
	{
		// Setup the next file.
		//.....................
		lpAttach[idx].ulReserved = 0;
		lpAttach[idx].flFlags = 0;
		lpAttach[idx].nPosition = (ULONG)(-1);
		lpAttach[idx].lpFileType = NULL;

		if (bMoreThanOne)
		{
			*lpFileInsert = 0;
			StringCbCatEx((LPTSTR)&szFileName,sizeof(szFileName),lpTempFilePtr,NULL,NULL,
						   dwStringSafeFlag);
			iFileNameLength = lstrlen(lpTempFilePtr);
		}
		// Get a pointer to the file name and file extension if
		// we need it later.
		//.....................................................
		lpFileExtension = PathFindExtension((LPCTSTR)szFileName);
		lpFileName = PathFindFileName((LPCTSTR)szFileName);

		lpAttach[idx].lpszPathName = (LPTSTR)PvAllocMore(lstrlen(szFileName) + 1,
													    (LPVOID)lpAttach);

		if(!lpAttach[idx].lpszPathName)
		{
			goto FileEnd;
		}
		lpAttach[idx].lpszFileName = (LPTSTR)PvAllocMore(lstrlen(lpFileName) + 1,
														(LPVOID)lpAttach);

		if(!lpAttach[idx].lpszFileName)
		{
			goto FileEnd;
		}
		StringCbCopy((LPTSTR)lpAttach[idx].lpszPathName,(lstrlen(szFileName) + 1),
					 (LPCTSTR)&szFileName);
		StringCbCopy((LPTSTR)lpAttach[idx].lpszFileName,(lstrlen(lpFileName) + 1),
					 (LPCTSTR)lpFileName);

		// Point to the next file selected. Get past the
		// trailing null byte.
		//..............................................
		lpTempFilePtr += (int)(iFileNameLength + 1);

		// Process the next file.
		//.......................
		idx++;
		ulNumberOfFiles--;
	}
	// Free the memory of the old file list.
	//......................................
	bErr = PvFree((LPBYTE)lpAttachT);

	if (!bErr)
	{
		ulResult = SUCCESS_SUCCESS;

		// Return the new file list.
		//..........................
		*lppAttach = lpAttach;
		(*lpcAttach) += ulTotalFiles;
	}

	FileEnd:

    if(ulResult)
	{
		if (lpAttach)
		{
			PvFree((LPBYTE)lpAttach);
		}
	}
	// See if we want to wipe the original files or not.
	//..................................................
	if (bWipeAfterAttach && lpOriginalFiles && ulResult == SUCCESS_SUCCESS)
	{
		bWipeFiles = TRUE;
		bCancelOperation = FALSE;
		DeleteWipeFiles(lpOriginalFiles,&ofn);
	}
	if (lpOriginalFiles)
	{
		ZeroMemory(lpOriginalFiles,((64 * 1024) - 1));
		DeallocateMemory(lpOriginalFiles);
	}

    return(ulResult);
}

// Special hook for open file dialog box for attaching files to an e-mail message.
// Adds a compress and encrypt and wipe check boxes.
//................................................................................
UINT CALLBACK MyAttachOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	static HWND		hWndParent;
	UINT			uCheck;
	LPHELPINFO		lphi;

	switch (uiMsg)
	{
		case WM_INITDIALOG:
		{
			bShowPreviousEncFolder = FALSE;
			CheckDlgButton(hDlg,IDC_COMPANDENC,BST_CHECKED);
			hWndParent = GetParent(hDlg);
			SetMyIcon(hWndParent);
			CenterWindow(hWndParent,hMainWindow);
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
				case IDC_COMPANDENC:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_COMPANDENC);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						bCompressAndEncrypt = FALSE;
						EnableWindow(GetDlgItem(hDlg,IDC_USE_ENC_FOLDER),FALSE);
					}
					else
					{
						uCheck = BST_CHECKED;
						bCompressAndEncrypt = TRUE;
						EnableWindow(GetDlgItem(hDlg,IDC_USE_ENC_FOLDER),TRUE);
					}
					CheckDlgButton(hDlg,IDC_COMPANDENC,uCheck);

					// Allow wipe original if no admin account or admin allows it.
					//............................................................
					if (!bAa || (bAa && (cfg.V1.dwV3 & PERMIT_WIPE_ORIGINAL)) || 
					   (bAa && !bRestrictionsInEffect))
					{
						// If we have checked the compress and encrypt checkbox
						// we have to enable the wipe after encrypt checkbox.
						//.....................................................
						if (bCompressAndEncrypt == TRUE)
						{
							EnableWindow(GetDlgItem(hDlg,IDC_WIPEAFTERATTACH),TRUE);
						}
						else
						{
							// Uncheck and disable window.
							//............................
							CheckDlgButton(hDlg,IDC_WIPEAFTERATTACH,BST_UNCHECKED);
							EnableWindow(GetDlgItem(hDlg,IDC_WIPEAFTERATTACH),FALSE);
							bWipeAfterAttach = FALSE;
						}
					}
				}
				break;

				case IDC_WIPEAFTERATTACH:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_WIPEAFTERATTACH);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						bWipeAfterAttach = FALSE;
					}
					else
					{
						uCheck = BST_CHECKED;
						bWipeAfterAttach = TRUE;
					}
					CheckDlgButton(hDlg,IDC_WIPEAFTERATTACH,uCheck);
				}
				break;

				case IDC_USE_ENC_FOLDER:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_USE_ENC_FOLDER);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						bShowPreviousEncFolder = FALSE;
					}
					else
					{
						uCheck = BST_CHECKED;
						bShowPreviousEncFolder = TRUE;
					}
					CheckDlgButton(hDlg,IDC_USE_ENC_FOLDER,uCheck);
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			lphi = (LPHELPINFO)lParam;
			if (lphi->iContextType == HELPINFO_WINDOW)
			{
				if (lphi->iCtrlId == IDC_WIPEAFTERATTACH || lphi->iCtrlId == IDC_COMPANDENC ||
					lphi->iCtrlId == IDC_USE_ENC_FOLDER)
				{
					PopupHelp(hDlg,lParam);
					return(TRUE);
				}
			}
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	}
	return(FALSE);
}

// CopyAttachment
//
//  Purpose:
//      Called in support of GetNextFile() to re-build an array
//      of chained MapiFileDescs.
//
//  Parameters:
//      lpParent        - Parent memory that allocations get chained to.
//      lpDest          - Destination Recipient.
//      lpSrc           - Source Recipient.
//
//  Return:
//      Void.
//......................................................................
ULONG CopyAttachment(lpMapiFileDesc lpParent, lpMapiFileDesc lpDest, lpMapiFileDesc lpSrc)
{
    lpDest->ulReserved = lpSrc->ulReserved;
    lpDest->flFlags = lpSrc->flFlags;
    lpDest->nPosition = lpSrc->nPosition;
    lpDest->lpFileType = lpSrc->lpFileType;

    if (lpSrc->lpszPathName)
    {
		lpDest->lpszPathName = (LPTSTR)PvAllocMore(lstrlen(lpSrc->lpszPathName) + 1,
												  (LPVOID)lpParent);

		if (!lpDest->lpszPathName)
		{
			return MAPI_E_INSUFFICIENT_MEMORY;
		}
		StringCbCopy(lpDest->lpszPathName,(lstrlen(lpSrc->lpszPathName) + 1),
					 lpSrc->lpszPathName);
    }
    else
	{
		lpDest->lpszPathName = NULL;
	}
    if (lpSrc->lpszFileName)
    {
		lpDest->lpszFileName = (LPTSTR)PvAllocMore(lstrlen(lpSrc->lpszFileName) + 1,
											      (LPVOID)lpParent);

		if (!lpDest->lpszFileName)
		{
			return MAPI_E_INSUFFICIENT_MEMORY;
		}
		StringCbCopy(lpDest->lpszFileName,(lstrlen(lpSrc->lpszFileName) + 1),
					 lpSrc->lpszFileName);
    }
    else
	{
		lpDest->lpszFileName = NULL;
	}

    return SUCCESS_SUCCESS;
}

// Build a central directory of all the messages.
//...............................................
BOOL BuildMsgCentralDir()
{
	HCURSOR			hOldCur;
	LPMSGID			lpMsgDup;
	BOOL			bErr = TRUE;
	lpMapiMessage	lpMsg;
	int				i = 0;
	int				iFirst;
	int				iLast;
	DWORD			dwSizeMsgId;
	ULONG			ulResult;
	DWORD			dwMsgs;
	LPBYTE			lpEmailMsg;
	LPBYTE			lpEmailMsgDup;
	DWORD			dwLength;
	DWORD			dwTemp;
	DWORD			dwSearchLength;
	BOOL			bResult;
	DWORD			dwFormat;
	TCHAR			szMsgID[516];
	TCHAR			szSeedMsgID[516];

	iMsgsSelected = 0;
	dwSizeMsgId = sizeof(MSGID);
	iTotalMsgs = -1;
	dwMsgs = 0;

	lpMsgList = AllocateMemory(sizeof(MSGID) * MAX_MSGS);
	if (!lpMsgList)
	{
		goto BuildEnd;
	}
	lpMsgDup = lpMsgList;

	// Display the logon dialog box.
	//..............................
	hDlgCurrent = 0;
	hDlgCurrent = CreateDialog(hInst,TEXT("READMAILMAPI"),hMainWindow,
							  (DLGPROC)CenterDlgBoxProc);

	if (!hDlgCurrent)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto BuildEnd;
	}

	hOldCur = SetCursor(hCursorWait);

	ulResult = MAPIFindNext(lHandle,(ULONG)hMainWindow,NULL,NULL,
									 MAPI_LONG_MSGID,0,(LPTSTR)&szMsgID);

	if (ulResult)
	{
		if (ulResult != MAPI_E_NO_MESSAGES)
		{
			SetLastError(ulResult + MAPI_BASE);
			ErrorProcedure(lpMapiDllName,IDS_MAPI_FINDNEXT,MB_OK);
			goto BuildEnd;
		}
	}

	while (ulResult == SUCCESS_SUCCESS)
	{
		// Check to see if we have reached our limit of 20000 msgs.
		//.........................................................
		if (dwMsgs >= MAX_MSGS)
		{
			MessageBoxProc(hMainWindow,IDS_PROGRAMLIMIT,IDS_TOOMANYMSGS,
						   MB_ICONINFORMATION | MB_OK | MB_HELP,MB_ICONINFORMATION,0);
			break;
		}
		// Get the next message.
		//......................
		ulResult = MAPIReadMail(lHandle,(ULONG)hMainWindow,szMsgID,
								MAPI_PEEK | MAPI_SUPPRESS_ATTACH,0,&lpMsg);

		if (ulResult != SUCCESS_SUCCESS)
		{
			SetLastError(ulResult + MAPI_BASE);
			ErrorProcedure(lpMapiDllName,IDS_MAPI_READ_MAIL,MB_OK);
			goto BuildEnd;
		}
		else
		{
			// Setup the address for the message.
			//...................................
			dwMsgs++;
			iTotalMsgs++;
			__asm
			{
				mov		eax,iTotalMsgs
				mov		ecx,dwSizeMsgId
				mul		ecx
				add		eax,lpMsgList
				mov		lpMsgDup,eax
			}
			if (lpMsg->nFileCount)
			{
				lpMsgDup->bHasAttach = TRUE;
			}
			if (lpMsg->flFlags & MAPI_UNREAD)
			{
				lpMsgDup->bUnRead = TRUE;
			}
			// Setup the message ID string.
			//.............................
			lpMsgDup->lpszMsgID = AllocateMemory(lstrlen((LPCTSTR)&szMsgID) + 1);
			if (!lpMsgDup->lpszMsgID)
			{
				goto BuildEnd;
			}
			StringCbCopy((LPTSTR)lpMsgDup->lpszMsgID,(lstrlen((LPCTSTR)&szMsgID) + 1),
						 (LPCTSTR)&szMsgID);

			// Setup the originator.
			//......................
			if (lpMsg->lpOriginator && lpMsg->lpOriginator->lpszName)
			{
				lpMsgDup->lpszFrom = AllocateMemory(lstrlen(lpMsg->lpOriginator->lpszName) + 1);
				if (!lpMsgDup->lpszFrom)
				{
					goto BuildEnd;
				}
				StringCbCopy((LPTSTR)lpMsgDup->lpszFrom,
							 (lstrlen(lpMsg->lpOriginator->lpszName) + 1),
							 (LPCTSTR)lpMsg->lpOriginator->lpszName);
			}
			// Setup the subject.
			//...................
			if (lpMsg->lpszSubject)
			{
				lpMsgDup->lpszSubject = AllocateMemory(lstrlen(lpMsg->lpszSubject) + 1);
				if (!lpMsgDup->lpszSubject)
				{
					goto BuildEnd;
				}
				StringCbCopy((LPTSTR)lpMsgDup->lpszSubject,(lstrlen(lpMsg->lpszSubject) + 1),
							 (LPCTSTR)lpMsg->lpszSubject);
			}
			// Setup the date received.
			//.........................
			if (lpMsg->lpszDateReceived)
			{
				lpMsgDup->lpszDateRec = AllocateMemory(lstrlen(lpMsg->lpszDateReceived) + 1);
				if (!lpMsgDup->lpszDateRec)
				{
					goto BuildEnd;
				}
				StringCbCopy((LPTSTR)lpMsgDup->lpszDateRec,(lstrlen(lpMsg->lpszDateReceived) + 1),
							 (LPCTSTR)lpMsg->lpszDateReceived);
			}
			// If we do not have any message text we do not check to see if
			// encrypted.
			//.............................................................
			if (!lpMsg->lpszNoteText)
			{
				goto NotEncrypted;
			}
			// Determine if the message is encrypted, and the format.
			//.......................................................
			lpEmailMsg = lpMsg->lpszNoteText;
			lpEmailMsgDup = lpEmailMsg;
			dwLength = (lstrlen((LPCTSTR)lpEmailMsg) + 1);
			dwTemp = 0;
			lpMsgDup->bEncrypted = FALSE;

			// Scan for at least 6 line feed characters in the message.
			//.........................................................
			__asm
			{
				mov		ecx,dwLength
				mov		esi,lpEmailMsg
			L1:	lodsb
				cmp		al,0x00
				je		L3
				cmp		al,0x0a
				jne		L2
				inc		dwTemp
			L2:	dec		ecx
				jnz		L1
			L3:	cmp		dwTemp,6
				jb		NotEncrypted
			}
			// Check for the trailing header first.
			//....................................
			bResult = SearchFor((LPBYTE)&Footer1,35,(LPBYTE)lpEmailMsg,dwLength);
			if (!bResult)
			{	
				goto NotEncrypted;
			}
			// Check for the header to see if we have a valid tsc encrypted message.
			//......................................................................
			bResult = SearchFor((LPBYTE)&Header1,37,(LPBYTE)lpEmailMsg,dwLength);
			if (!bResult)
			{
				goto NotEncrypted;
			}
			// Now get past the next two line feed characters.
			//................................................
			lpEmailMsgDup = lpSearchEDI;
			dwSearchLength = (dwLength + lpEmailMsg - lpEmailMsgDup);

			for (i = 0; i < 2; i++)
			{
				bResult = SearchFor(lpLineFeed,1,lpEmailMsgDup,dwSearchLength);
				if (!bResult)
				{
					goto NotEncrypted;
				}
				lpEmailMsgDup = lpSearchEDI;
				lpEmailMsgDup++;
				dwSearchLength = (dwLength + lpEmailMsg - lpEmailMsgDup);
			}
			// The next phrase should be the clipboard format.
			//................................................
			bResult = SearchFor((LPBYTE)&Header1[136],18,lpEmailMsgDup,dwSearchLength);
			if (!bResult)
			{
				goto NotEncrypted;
			}
			lpEmailMsgDup = lpSearchEDI;

			// Get the next byte of data which is our clipboard format.
			// Leave it in the zero based format for checking for the
			// type of format - rtf, html, or text.
			//.........................................................
			__asm
			{
				mov		edi,lpEmailMsgDup
				add		edi,18
				movzx	eax,byte ptr [edi]
				and		eax,0x0f
				mov		dwFormat,eax
			}
			// If we have a format we cannot display or save go on to the next
			// message.
			//................................................................
			if (dwFormat == 0 || dwFormat == 4)
			{
				lpMsgDup->bEncrypted = TRUE;
				lpMsgDup->dwClipFormat = dwFormat;
			}
		
		  NotEncrypted:

			// Determine the proper icon to use in the initial display.
			//.........................................................
			lpMsgDup->iImageIdx = 0;

			if (!lpMsgDup->bUnRead && lpMsgDup->bHasAttach && lpMsgDup->bEncrypted)
			{
				lpMsgDup->iImageIdx = 7;
			}
			else if (!lpMsgDup->bUnRead && lpMsgDup->bEncrypted && !lpMsgDup->bHasAttach)
			{
				lpMsgDup->iImageIdx = 5;
			}
			else if (!lpMsgDup->bUnRead && lpMsgDup->bHasAttach && !lpMsgDup->bEncrypted)
			{
				lpMsgDup->iImageIdx = 3;
			}
			else if (!lpMsgDup->bUnRead && !lpMsgDup->bHasAttach && !lpMsgDup->bEncrypted)
			{
				lpMsgDup->iImageIdx = 1;
			}
			else if (lpMsgDup->bUnRead && lpMsgDup->bHasAttach && lpMsgDup->bEncrypted)
			{
				lpMsgDup->iImageIdx = 6;
			}
			else if (lpMsgDup->bUnRead && !lpMsgDup->bHasAttach && lpMsgDup->bEncrypted)
			{
				lpMsgDup->iImageIdx = 4;
			}
			else if (lpMsgDup->bUnRead && lpMsgDup->bHasAttach && !lpMsgDup->bEncrypted)
			{
				lpMsgDup->iImageIdx = 2;
			}
			lpMsgDup->bDeleteMsg = FALSE;

			// Setup for getting the next message.
			//....................................
			MAPIFreeBuffer(lpMsg);

			StringCbCopy((LPTSTR)&szSeedMsgID,sizeof(szSeedMsgID),(LPCTSTR)&szMsgID);
			ulResult = MAPIFindNext(lHandle,(ULONG)hMainWindow,NULL,szSeedMsgID,
									MAPI_LONG_MSGID,0,szMsgID);
			if (ulResult)
			{
				if (ulResult != MAPI_E_NO_MESSAGES)
				{
					SetLastError(ulResult + MAPI_BASE);
					ErrorProcedure(lpMapiDllName,IDS_MAPI_FINDNEXT,MB_OK);
					goto BuildEnd;
				}
			}
		}
	}
	// See if we want to sort by date in decending order.
	//...................................................
	if (cfg.cp.bDecending)
	{
		iFirst = 0;
		iLast = iTotalMsgs;

		while(TRUE)
		{
			if (iFirst == iLast || iFirst > iLast)
			{
				break;
			}
			__asm
			{
				mov		edi,lpMsgList
				mov		esi,lpMsgList
				mov		eax,iFirst
				mov		ecx,dwSizeMsgId;
				mul		ecx
				add		esi,eax
				mov		eax,iLast
				mul		ecx
				add		edi,eax
			L4:	mov		al,byte ptr[edi]
				movsb
				mov		byte ptr [esi-1],al
				dec		ecx
				jnz		L4
			}
			iFirst++;
			iLast--;
		}
	}
	// Set the focus on the first message.
	//....................................
	lpMsgList->State = LVIS_FOCUSED;
	iTotalMsgs++;

	bErr = FALSE;

	BuildEnd:

	// Destroy the modless dialog box.
	//................................
	if (hDlgCurrent)
	{
		DestroyWindow(hDlgCurrent);
		hDlgCurrent = 0;
	}
	return(bErr);
}

// Delete the fields in the message list for each message.
//........................................................
DeleteMsgListItems()
{
	LPMSGID			lpMsgDup;
	int				i;
	DWORD			dwSizeMSGID;

	dwSizeMSGID = sizeof(MSGID);

	for (i = 0; i < iTotalMsgs; i++)
	{
		__asm
		{
			mov		eax,i
			mov		ecx,dwSizeMSGID
			mul		ecx
			add		eax,lpMsgList
			mov		lpMsgDup,eax
		}
		if (lpMsgDup->lpszDateRec)
		{
			DeallocateMemory(lpMsgDup->lpszDateRec);
			lpMsgDup->lpszDateRec = 0;
		}
		if (lpMsgDup->lpszFrom)
		{
			DeallocateMemory(lpMsgDup->lpszFrom);
			lpMsgDup->lpszFrom = 0;
		}
		if (lpMsgDup->lpszMsgID)
		{
			DeallocateMemory(lpMsgDup->lpszMsgID);
			lpMsgDup->lpszMsgID = 0;
		}
		if(lpMsgDup->lpszSubject)
		{
			DeallocateMemory(lpMsgDup->lpszSubject);
			lpMsgDup->lpszSubject = 0;
		}
	}
}

// Save the file attachments to the e-mail message.
//.................................................
VOID SaveFileAttachments(HWND hWnd)
{
	ULARGE_INTEGER		uliFreeCallerBytes;
	ULARGE_INTEGER		uliTotalBytes;
	LARGE_INTEGER		li;
    ULONG				idx;
	int					i;
	int					iComp;
	HRESULT				hr = ERROR_SUCCESS;
	int					iFilesSaved = 0;
	LPTSTR				lpDestInsert;
	LPTSTR				lpFileName;
	DWORD				dwPathLength;
	DWORD				dwTotalLength;
	BOOL				bResult;
	BROWSEINFO			bi;
    LPITEMIDLIST		lpidl;
    LPMALLOC			lpMalloc;
	lpMapiFileDesc		lpFile;
	TCHAR				szRoot[16];
	TCHAR				szBuffer[128];
	TCHAR				szFileToSave[MAX_PATH];

	SetCurrentDirectory((LPCTSTR)&szPreviousDestinationDir);

	// Select a destination for the e-mail file attachments.
	//......................................................
	while(TRUE)
	{
		ZeroMemory(&szFileToSave,sizeof(szFileToSave));

		if (SUCCEEDED(SHGetMalloc(&lpMalloc))) 
		{
			ZeroMemory(&bi,sizeof(bi));
			bi.hwndOwner = hWnd;
			bi.pszDisplayName = 0;
			bi.lpszTitle = TEXT("Select a Destination for the file attachments.");
			bi.pidlRoot = 0;
			bi.ulFlags = BIF_RETURNONLYFSDIRS;

			// If we can use the new style of the dialog box, do it.
			//......................................................
			if (bUseNew)
			{
				hr = CoInitialize(NULL);
				if (SUCCEEDED(hr))
				{
					bi.ulFlags |= BIF_NEWDIALOGSTYLE;
				}
			}
			bi.lpfn = BrowseCallbackProc;

			lpidl = SHBrowseForFolder(&bi);

			if (bUseNew && SUCCEEDED(hr))
			{
				CoUninitialize();
			}
			if (lpidl) 
			{
				bResult = SHGetPathFromIDList(lpidl,(LPSTR)&szFileToSave);
				lpMalloc->lpVtbl->Free(lpMalloc,lpidl);
				lpMalloc->lpVtbl->Release(lpMalloc);
			}
			else
			{
				// We cancelled out.
				//..................
				return;
			}
			SaveDirName((LPBYTE)&szFileToSave,SAVE_DESTINATION,FALSE);

			// See if we have any free disk space. cd rom drives that
			// are not writable will report zero.
			//.......................................................
			ZeroMemory(&szRoot,sizeof(szRoot));
			CopyMemory(&szRoot,&szFileToSave,3);
			bResult = GetDiskFreeSpaceEx((LPCTSTR)&szRoot,
										(PULARGE_INTEGER)&uliFreeCallerBytes.QuadPart,
										(PULARGE_INTEGER)&uliTotalBytes.QuadPart,NULL);
			if (!bResult)
			{
				ErrorProcedure((LPTSTR)&szFileToSave,IDS_GETFREEDSKSPACE,MB_OK);
				return;
			}
			if (uliFreeCallerBytes.QuadPart == 0)
			{
				SetLastError(IDS_NOSPACE);
				ErrorProcedure((LPTSTR)&szFileToSave,IDS_GETFREEDSKSPACE,MB_OK);
				continue;
			}
			// If we got this far with no error, we have a valid
			// destination.
			//..................................................
			break;
		}
		else
		{
			MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_SELECTDIR,
						   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
			return;
		}
	}
	lpDestInsert = PathAddBackslash((LPTSTR)&szFileToSave);
	dwPathLength = lstrlen((LPCTSTR)&szFileToSave);

	for (i = 0; i < iFilesSelected; i++)
	{
		idx = lpInt[i];
		lpFile = &lpReadMsg->lpFiles[idx];
		lpFileName = PathFindFileName((LPCTSTR)lpFile->lpszFileName);
		dwTotalLength = (dwPathLength + lstrlen((LPCTSTR)lpFileName) + 1);
		if (dwTotalLength > MAX_PATH)
		{
			SetLastError(IDS_M_PATHTOOLONG);
			ErrorProcedure((LPTSTR)lpFileName,IDS_APPENDSTRINGS,MB_OK);
			continue;
		}
		*lpDestInsert = 0;
		StringCbCatEx((LPTSTR)&szFileToSave,sizeof(szFileToSave),(LPCTSTR)lpFileName,NULL,
					   NULL,dwStringSafeFlag);

		// If the destination and source are the same we have to quit.
		//............................................................
		iComp = CompareString(LOCALE_USER_DEFAULT,NORM_IGNORECASE,
							 (LPCTSTR)&szFileToSave,-1,(LPCTSTR)lpFile->lpszFileName,-1);
		if (iComp == CSTR_EQUAL)
		{
			MessageBoxProc(hMainWindow,IDS_INPUT_ERROR,IDS_NOCOPYTOSAME,MB_ICONHAND | MB_OK,
						   MB_ICONHAND,0);
			break;
		}
		// Use CopyFile to carry out the operation.
		//.........................................
		if(!CopyFile((LPCTSTR)lpFile->lpszFileName,(LPCTSTR)&szFileToSave,TRUE))
		{
			ErrorProcedure((LPTSTR)lpFile->lpszFileName,IDS_COPYFILE,MB_OK);
			break;
		}
		else
		{
			// Check to see if we have an encrypted or packed file to take care of.
			//.....................................................................
			li.QuadPart = IsTscFileValid((LPBYTE)szFileToSave);
			if (li.QuadPart != -1)
			{
				CopyMemory(&szDestination,&szFileToSave,MAX_PATH);
				CopyMemory(&szFileToDecipher,&szFileToSave,MAX_PATH);
				PathRemoveFileSpec((LPTSTR)&szDestination);
				PathAddBackslash((LPTSTR)&szDestination);
				DecryptAFile((LPBYTE)&szFileToDecipher);
			}
			else
			{
				// Check to see if we have just a packed file.
				//............................................
				hInputFile = IsValidPackedFile((LPBYTE)&szFileToSave,FALSE);
				if (hInputFile)
				{
					CopyMemory(&szFileName,&szFileToSave,MAX_PATH);
					CopyMemory(&szDestination,&szFileToSave,MAX_PATH);
					PathRemoveFileSpec((LPTSTR)&szDestination);
					UnpackAFile((LPBYTE)&szFileName);
				}
			}
		}
		iFilesSaved++;
	}
	StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szAttachSaved,iFilesSaved,
				    iFilesSelected);
	MessageBoxProc(hMainWindow,IDS_ADVISORY,(UINT)szBuffer,MB_ICONINFORMATION | MB_OK,
									 MB_ICONINFORMATION,0);
}

// Center small modeless dialog boxes.
//....................................
LRESULT CALLBACK CenterDlgBoxProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Center the dialog box.
			//.......................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return FALSE;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Send a notification message with the ip address we are listening on.
//.....................................................................
VOID SendNotificationMsg()
{
	MapiMessage			msgSend;
	ULONG				ulError;
	BOOL				bResult;
	TCHAR				szChatMsg[128];
					
	if (!bLoggedOn)
	{
		bResult = LogonToMapi(IDH_CHAT,FALSE,FALSE);
		if (!bResult)
		{
			return;
		}
	}
	ZeroMemory(&msgSend,sizeof(MapiMessage));
	ZeroMemory(&szChatMsg,sizeof(szChatMsg));

	msgSend.lpszSubject = TEXT("Chat");
	StringCbPrintf((LPTSTR)&szChatMsg,sizeof(szChatMsg),TEXT("Listening on: %s\n"),
					&szIPAddress);
	msgSend.lpszNoteText = (LPTSTR)&szChatMsg;

	ulError = MAPISendMail(lHandle,(ULONG)hMainWindow,&msgSend,MAPI_DIALOG,0L);
	if (ulError != SUCCESS_SUCCESS)
	{
		SetLastError(ulError + MAPI_BASE);
		ErrorProcedure(lpMapiDllName,IDS_MAPI_SEND_MAIL,MB_OK);
	}
	// Log off from mapi.
	//...................
	if (bLoggedOn)
	{
		LogoffFromMapi(FALSE,FALSE);
	}
}
